package com.liquidnet.service.sweet.service.impl;

import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.liquidnet.commons.lang.util.IDGenerator;
import com.liquidnet.service.base.ResponseDto;
import com.liquidnet.service.sweet.entity.SweetRichtext;
import com.liquidnet.service.sweet.entity.SweetRichtextMdsk;
import com.liquidnet.service.sweet.mapper.SweetRichtextMdskMapper;
import com.liquidnet.service.sweet.service.ISweetRichtextMdskService;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.liquidnet.service.sweet.utils.RedisDataUtils;
import com.liquidnet.service.sweet.utils.RedisMDSKDataUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.time.LocalDateTime;

/**
 * <p>
 * 电子宣传手册富文本表 服务实现类
 * </p>
 *
 * @author liquidnet
 * @since 2021-08-09
 */
@Service
public class SweetRichtextMdskServiceImpl extends ServiceImpl<SweetRichtextMdskMapper, SweetRichtextMdsk> implements ISweetRichtextMdskService {

    @Autowired
    private SweetRichtextMdskMapper sweetRichtextMdskMapper;
    @Autowired
    private RedisMDSKDataUtils redisDataUtils;

    @Override
    public ResponseDto<SweetRichtextMdsk> get(String manualId, Integer type) {
        try {
            return ResponseDto.success(sweetRichtextMdskMapper.selectOne(Wrappers.lambdaQuery(SweetRichtextMdsk.class).eq(SweetRichtextMdsk::getManualId, manualId).eq(SweetRichtextMdsk::getType, type)));
        } catch (Exception e) {
            return ResponseDto.failure();
        }
    }

    @Override
    public ResponseDto<Boolean> add(String manualId, String details, String local, String pirUrl, Integer type) {
        try {
            int count = sweetRichtextMdskMapper.selectCount(Wrappers.lambdaQuery(SweetRichtextMdsk.class).eq(SweetRichtextMdsk::getManualId, manualId).eq(SweetRichtextMdsk::getType, type));
            if(count>0){
                return ResponseDto.failure("不能重复添加");
            }
            SweetRichtextMdsk sweetRichtext = SweetRichtextMdsk.getNew();
            sweetRichtext.setRichtextId(IDGenerator.nextSnowId());
            sweetRichtext.setManualId(manualId);
            if (type == 5) {
                sweetRichtext.setLocal(local);
                sweetRichtext.setDetails(details);
            } else if (type == 2) {
                sweetRichtext.setPicUrl(pirUrl);
            }else{
                sweetRichtext.setDetails(details);
            }
            sweetRichtext.setType(type);
            sweetRichtext.setCreatedAt(LocalDateTime.now());
            sweetRichtextMdskMapper.insert(sweetRichtext);
        } catch (Exception e) {
            return ResponseDto.failure();
        }
        return ResponseDto.success();
    }

    @Override
    public ResponseDto<Boolean> change(String manualId, String details, String local, String pirUrl, Integer type) {
        try {
            SweetRichtextMdsk sweetRichtext = SweetRichtextMdsk.getNew();
            sweetRichtext.setRichtextId(IDGenerator.nextSnowId());
            sweetRichtext.setManualId(manualId);
            sweetRichtext.setDetails(details);
            if (type == 5) {
                sweetRichtext.setLocal(local);
            } else if (type == 2) {
                sweetRichtext.setPicUrl(pirUrl);
            }
            sweetRichtext.setType(type);
            sweetRichtext.setCreatedAt(LocalDateTime.now());
            sweetRichtextMdskMapper.update(sweetRichtext, Wrappers.lambdaUpdate(SweetRichtextMdsk.class).eq(SweetRichtextMdsk::getManualId, manualId).eq(SweetRichtextMdsk::getType, type));

            redisDataUtils.setRichTextRedisData(manualId,type.toString(),sweetRichtext);
        } catch (Exception e) {
            return ResponseDto.failure();
        }
        return ResponseDto.success();
    }

}
