package com.liquidnet.service.goblin.service;

import com.github.pagehelper.PageInfo;
import com.liquidnet.service.base.ResponseDto;
import com.liquidnet.service.goblin.dto.manage.GoblinGoodsAnticipateAddParam;
import com.liquidnet.service.goblin.dto.manage.GoblinGoodsAnticipateParam;
import com.liquidnet.service.goblin.dto.manage.GoblinGoodsAnticipateUpdateParam;
import com.liquidnet.service.goblin.dto.manage.GoblinGoodsAnticipateValueParam;
import com.liquidnet.service.goblin.dto.vo.GoblinGoodsAnticipateVo;

import java.util.List;

/**
 * <p>
 * 预约表 服务类
 * </p>
 *
 * @author liquidnet
 * @since 2022-04-07
 */
public interface IGoblinGoodsAnticipateService{

    /**
     * 分页获取预约商品列表
     * @param goodsAnticipateParam :
     * @return ：List<GoblinGoodsAnticipateVo>
     */
    ResponseDto<PageInfo<GoblinGoodsAnticipateVo>> list(GoblinGoodsAnticipateParam goodsAnticipateParam);

    ResponseDto<Object> add(GoblinGoodsAnticipateAddParam goodsAnticipateAddParam);

    ResponseDto<Object> update(GoblinGoodsAnticipateUpdateParam goodsAnticipateUpdateParam);

    ResponseDto<Object> updatePeople(String antId,Long people);

    ResponseDto<Object> delete(String antId);

    ResponseDto<Object> getSkus(String spuId);

    ResponseDto<Object> userAbout(String antId, String skuId,String uid, String phone,Integer state);

    ResponseDto<Object> addAnticipateValues(List<GoblinGoodsAnticipateValueParam> list);

    ResponseDto<Object> updateAnticipateValues(List<GoblinGoodsAnticipateValueParam> list);
}
