package com.liquidnet.service.sweet.utils;

import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.liquidnet.common.cache.redis.util.RedisUtil;
import com.liquidnet.commons.lang.util.*;
import com.liquidnet.service.base.SqlMapping;
import com.liquidnet.service.base.constant.MQConst;
import com.liquidnet.service.kylin.constant.KylinRedisConst;
import com.liquidnet.service.sweet.constant.SweetConstant;
import com.liquidnet.service.sweet.dto.SweetManualAppletDto;
import com.liquidnet.service.sweet.dto.SweetManualArtistList2Dto;
import com.liquidnet.service.sweet.dto.SweetManualArtistListDto;
import com.liquidnet.service.sweet.dto.SweetManualArtistStageListDto;
import com.liquidnet.service.sweet.dto.param.poster.SweetStrawberryParam;
import com.liquidnet.service.sweet.dto.vo.IntegralActivityDrawVo;
import com.liquidnet.service.sweet.dto.vo.IntegralActivityVo;
import com.liquidnet.service.sweet.dto.vo.TempBannerVo;
import com.liquidnet.service.sweet.entity.*;
import com.liquidnet.service.sweet.mapper.*;
import com.liquidnet.service.sweet.param.SweetCityVoteParam;
import com.liquidnet.service.sweet.vo.*;
import jodd.util.ArraysUtil;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.time.LocalDateTime;
import java.util.*;
import java.util.stream.Collectors;

@Component
@Slf4j
public class RedisDataUtils {

    @Autowired
    private RedisUtil redisUtil;
    @Autowired
    private QueueUtils queueUtils;

    @Autowired
    private SweetManualMapper sweetManualMapper;
    @Autowired
    private SweetManualArtistsMapper sweetManualArtistsMapper;
    @Autowired
    private SweetRichtextMapper sweetRichtextMapper;
    @Autowired
    private SweetManualSortMapper sweetManualSortMapper;
    @Autowired
    private SweetManualNotifyMapper sweetManualNotifyMapper;
    @Autowired
    private SweetManualShopMapper sweetManualShopMapper;
    @Autowired
    private SweetArtistsMapper sweetArtistsMapper;


    public List<SweetManualAppletDto> setPushList() {
        String redisKey = SweetConstant.REDIS_KEY_SWEET_MANUAL_PUSH_LIST;
        List<SweetManualAppletDto> data = sweetManualMapper.getManualAppletDto();
        for (SweetManualAppletDto item : data) {
            if (!item.getIsMember().equals(1)) {
                item.setTimeSell(DateUtil.format(DateUtil.addMin(DateUtil.parse(item.getTimeSell(), "yyyy-MM-dd HH:mm:ss"), item.getPayCountdownMinute()), DateUtil.Formatter.yyyyMMddHHmmss));
            }
            item.setFieldName((String) redisUtil.getDB15RedisHGet(KylinRedisConst.FIELDS + ":" + item.getFieldId(), "name"));
            item.setCityName((String) redisUtil.getDB15RedisHGet(KylinRedisConst.FIELDS + ":" + item.getFieldId(), "city_name"));
            item.setLatitude((String) redisUtil.getDB15RedisHGet(KylinRedisConst.FIELDS + ":" + item.getFieldId(), "latitude"));
            item.setLongitude((String) redisUtil.getDB15RedisHGet(KylinRedisConst.FIELDS + ":" + item.getFieldId(), "longitude"));
        }
        redisUtil.set(redisKey, data);
        return data;
    }

    //获取电子手册列表 (城市)
    public List<SweetManualAppletDto> getPushList() {
        String redisKey = SweetConstant.REDIS_KEY_SWEET_MANUAL_PUSH_LIST;
        Object obj = redisUtil.get(redisKey);
        if (obj == null) {
            return setPushList();
        } else {
            return (List<SweetManualAppletDto>) obj;
        }
    }

    //获取电子手册演出详情
    public SweetManualAppletDto getAppletPerformance(String manualId) {
        List<SweetManualAppletDto> data = getPushList();
        SweetManualAppletDto returnData = SweetManualAppletDto.getNew();
        for (SweetManualAppletDto item : data) {
            if (item.getManualId().equalsIgnoreCase(manualId)) {
                returnData = item;
                break;
            }
        }
        return returnData;
    }

    public SweetManualArtistList2Dto setTimeList(String manualId, String content) {
        String redisKey = SweetConstant.REDIS_KEY_SWEET_MANUAL_TIME_LIST.concat(manualId);
        HashMap<String, Object> map = CollectionUtil.mapStringObject();
        map.put("manualId", manualId);
        List<SweetManualArtistListDto> data = sweetManualArtistsMapper.getManualList(map);

        //获取时间
        SweetManualAppletDto sweetManualAppletDto = getAppletPerformance(manualId);
        Date dateEnd = DateUtil.parse(sweetManualAppletDto.getTimeEnd(), DateUtil.DATE_SMALL_STR);
        Date dateStart = DateUtil.parse(sweetManualAppletDto.getTimeStart(), DateUtil.DATE_SMALL_STR);
        int intervalDay = (int) DateUtil.intervalDays(dateStart, dateEnd);
        ArrayList<String> list = CollectionUtil.arrayListString();
        list.add(DateUtil.format(dateStart, DateUtil.Formatter.yyyy_MM_dd));
        for (int i = 0; i < intervalDay; i++) {
            list.add(DateUtil.format(DateUtil.addDay(dateStart, i + 1), DateUtil.Formatter.yyyy_MM_dd));
        }

        //获取舞台
        List<SweetManualArtistStageListDto> stageData = sweetManualArtistsMapper.getStageNameList(map);

        SweetManualArtistList2Dto returnData = SweetManualArtistList2Dto.getNew();
        returnData.setDate(list);
        returnData.setData(data);
        returnData.setStage(stageData);
        redisUtil.set(redisKey, returnData);
        return returnData;
    }

    //获取时间表
    public SweetManualArtistList2Dto getTimeList(String manualId) {
        String redisKey = SweetConstant.REDIS_KEY_SWEET_MANUAL_TIME_LIST.concat(manualId);
        Object obj = redisUtil.get(redisKey);
        if (obj == null) {
            return setTimeList(manualId, null);
        } else {
            return (SweetManualArtistList2Dto) obj;
        }
    }

    public SweetRichtext setRichTextRedisData(String manualId, String type, SweetRichtext content) {
        String redisKey = SweetConstant.REDIS_KEY_SWEET_MANUAL_RICH_TEXT.concat(manualId).concat(":type:" + type);
        SweetRichtext sweetRichtext;
        if (content != null) {
            sweetRichtext = content;
        } else {
            sweetRichtext = sweetRichtextMapper.selectOne(Wrappers.lambdaQuery(SweetRichtext.class).eq(SweetRichtext::getManualId, manualId).eq(SweetRichtext::getType, type));
        }
        redisUtil.set(redisKey, sweetRichtext);
        return sweetRichtext;
    }

    //获取富文本详情
    public SweetRichtext getRichTextRedisData(String manualId, String type) {
        String redisKey = SweetConstant.REDIS_KEY_SWEET_MANUAL_RICH_TEXT.concat(manualId).concat(":type:" + type);
        Object obj = redisUtil.get(redisKey);
        if (obj == null) {
            return setRichTextRedisData(manualId, type, null);
        } else {
            return (SweetRichtext) obj;
        }
    }

    public List<String> setTagRedisData(String manualId) {
        String redisKey = SweetConstant.REDIS_KEY_SWEET_MANUAL_SORT.concat(manualId);
        SweetManualSort data = sweetManualSortMapper.selectOne(Wrappers.lambdaQuery(SweetManualSort.class).eq(SweetManualSort::getManualId, manualId));
        String[] arrays = data.getShowPosition().split(",");
        List<String> returnData = new ArrayList<>();
        for (String item : arrays) {
            returnData.add(item);
//            returnData.add(SweetConstant.ManualPosition.getMessage(item));
        }
        redisUtil.set(redisKey, returnData);
        return returnData;
    }

    //获取显示的标签
    public List<String> getTagRedisData(String manualId) {
        String redisKey = SweetConstant.REDIS_KEY_SWEET_MANUAL_SORT.concat(manualId);
        Object obj = redisUtil.get(redisKey);
        if (obj == null) {
            return setTagRedisData(manualId);
        } else {
            return (List<String>) obj;
        }
    }

    public List<SweetManualNotify> setNotifyRedisData(String manualId, List<SweetManualNotify> content) {
        String redisKey = SweetConstant.REDIS_KEY_SWEET_MANUAL_NOTIFY_LIST.concat(manualId);
        List<SweetManualNotify> data;
        if (content != null) {
            data = content;
        } else {
            data = sweetManualNotifyMapper.selectList(Wrappers.lambdaQuery(SweetManualNotify.class).eq(SweetManualNotify::getManualId, manualId).eq(SweetManualNotify::getStatus, 1));
        }
        redisUtil.set(redisKey, data);
        return data;
    }

    //获取通知
    public List<SweetManualNotify> getNotifyRedisData(String manualId) {
        String redisKey = SweetConstant.REDIS_KEY_SWEET_MANUAL_NOTIFY_LIST.concat(manualId);
        Object obj = redisUtil.get(redisKey);
        if (obj == null) {
            return setNotifyRedisData(manualId, null);
        } else {
            return (List<SweetManualNotify>) obj;
        }
    }

    public void deletePushListRedisData() {
        redisUtil.del(SweetConstant.REDIS_KEY_SWEET_MANUAL_PUSH_LIST);//列表
    }

    public void deleteTimeListRedisData(String manualId) {
        redisUtil.del(SweetConstant.REDIS_KEY_SWEET_MANUAL_TIME_LIST.concat(manualId));//列表
    }

    public void deleteSortRedisData(String manualId) {
        redisUtil.del(SweetConstant.REDIS_KEY_SWEET_MANUAL_SORT.concat(manualId));//列表
    }

    public void setArtistsRelationRedisVo(String uid, String artistsId, String manualId, String type) {

        LinkedList<String> sqls = CollectionUtil.linkedListString();
        LinkedList<Object[]> sqlsDataA = CollectionUtil.linkedListObjectArr();
        LocalDateTime now = LocalDateTime.now();

        String redisKey = SweetConstant.REDIS_KEY_SWEET_ARTISTS_RELATION.concat(uid).concat(":manualId:").concat(manualId);
        SweetArtistsRelationVo vo = getArtistsRelationRedisVo(uid, manualId);
        vo.setUid(uid);
        if (type.equalsIgnoreCase("sign")) {
            if (vo.getSignList() == null) {
                ArrayList<String> signList = CollectionUtil.arrayListString();
                signList.add(artistsId);
                vo.setSignList(signList);
                sqls.add(SqlMapping.get("sweet_user_relation.insert"));
                sqlsDataA.add(new Object[]{
                        uid, 2, artistsId, manualId, now
                });
            } else {
                if (vo.getSignList().contains(artistsId)) {
                    vo.getSignList().remove(artistsId);
                    sqls.add(SqlMapping.get("sweet_user_relation.delete"));
                    sqlsDataA.add(new Object[]{
                            uid, artistsId, manualId, 2
                    });
                } else {
                    vo.getSignList().add(artistsId);
                    sqls.add(SqlMapping.get("sweet_user_relation.insert"));
                    sqlsDataA.add(new Object[]{
                            uid, 2, artistsId, manualId, now
                    });
                }
            }
        } else if (type.equalsIgnoreCase("watch")) {
            if (vo.getWatchList() == null) {
                ArrayList<String> watchList = CollectionUtil.arrayListString();
                watchList.add(artistsId);
                vo.setWatchList(watchList);
                sqls.add(SqlMapping.get("sweet_user_relation.insert"));
                sqlsDataA.add(new Object[]{
                        uid, 1, artistsId, manualId, now
                });
            } else {
                if (vo.getWatchList().contains(artistsId)) {
                    vo.getWatchList().remove(artistsId);
                    sqls.add(SqlMapping.get("sweet_user_relation.delete"));
                    sqlsDataA.add(new Object[]{
                            uid, artistsId, manualId, 1
                    });
                } else {
                    vo.getWatchList().add(artistsId);
                    sqls.add(SqlMapping.get("sweet_user_relation.insert"));
                    sqlsDataA.add(new Object[]{
                            uid, 1, artistsId, manualId, now
                    });
                }
            }
        }
        redisUtil.set(redisKey, vo);

        queueUtils.sendMsgByRedis(MQConst.SweetQueue.ARTISTS_RELATION.getKey(),
                SqlMapping.gets(sqls, sqlsDataA));
    }

    //获取 签售
    //获取 想看
    public SweetArtistsRelationVo getArtistsRelationRedisVo(String uid, String manualId) {
        String redisKey = SweetConstant.REDIS_KEY_SWEET_ARTISTS_RELATION.concat(uid).concat(":manualId:").concat(manualId);
        Object obj = redisUtil.get(redisKey);
        if (obj == null) {
            return SweetArtistsRelationVo.getNew();
        } else {
            return (SweetArtistsRelationVo) obj;
        }
    }

    //获取 商铺
    public List<SweetManualShop> setManualShopRedisData(String manualId) {
        String redisKey = SweetConstant.REDIS_KEY_SWEET_SHOP.concat(manualId);
        List<SweetManualShop> list = sweetManualShopMapper.selectList(Wrappers.lambdaQuery(SweetManualShop.class).eq(SweetManualShop::getManualId, manualId).orderBy(true, false, SweetManualShop::getSort));
        redisUtil.set(redisKey, list);
        return list;
    }

    public List<SweetManualShop> getManualShopRedisData(String manualId) {
        String redisKey = SweetConstant.REDIS_KEY_SWEET_SHOP.concat(manualId);
        Object obj = redisUtil.get(redisKey);
        if (obj == null) {
            return setManualShopRedisData(manualId);
        } else {
            return (List<SweetManualShop>) obj;
        }
    }

    // 小程序演出提醒
    public void setSweetRemind(String openId, String unionId, String performancesId) {
        SweetRemindVo sweetRemindVo = SweetRemindVo.getNew();
        sweetRemindVo.setRemindId(IDGenerator.nextSnowId());
        sweetRemindVo.setCreatedAt(DateUtil.getNowTime());
        sweetRemindVo.setPerformancesId(performancesId);
        sweetRemindVo.setUnionId(unionId);
        sweetRemindVo.setOpenId(openId);

        LinkedList<String> sqls = CollectionUtil.linkedListString();
        LinkedList<Object[]> sqlsDataA = CollectionUtil.linkedListObjectArr();
        LocalDateTime now = LocalDateTime.now();
        sqls.add(SqlMapping.get("sweet_remind.insert"));
        sqlsDataA.add(new Object[]{
                sweetRemindVo.getRemindId(), sweetRemindVo.getOpenId(), sweetRemindVo.getUnionId(), sweetRemindVo.getPerformancesId(),
        });
        queueUtils.sendMsgByRedis(MQConst.SweetQueue.SWEET_REMIND_INSERT.getKey(),
                SqlMapping.gets(sqls, sqlsDataA));
    }

    // 艺人详情
    public SweetArtists setArtistsDetails(String artistsId) {
        String redisKey = SweetConstant.REDIS_KEY_SWEET_ARTISTS_DETAILS.concat(artistsId);
        SweetArtists sweetArtists = sweetArtistsMapper.selectOne(Wrappers.lambdaQuery(SweetArtists.class).eq(SweetArtists::getArtistsId, artistsId).eq(SweetArtists::getStatus, 1));
        redisUtil.set(redisKey, sweetArtists);
        return sweetArtists;
    }

    public SweetArtists getArtistsDetails(String artistsId) {
        String redisKey = SweetConstant.REDIS_KEY_SWEET_ARTISTS_DETAILS.concat(artistsId);
        Object obj = redisUtil.get(redisKey);
        if (obj == null) {
            return setArtistsDetails(artistsId);
        } else {
            return (SweetArtists) obj;
        }
    }

    //获取抽奖状态
    public int getLuckDrawStatus(String mobile, String luckDrawNum) {
        String redisKey = SweetConstant.REDIS_KEY_SWEET_LUCK_DRAW.concat(mobile).concat(":luckDrawNum:" + luckDrawNum);
        Object obj = redisUtil.get(redisKey);
        if (obj == null) {
            redisUtil.set(redisKey, 0);
            return 0;
        } else {
            return (int) redisUtil.get(redisKey);
        }
    }

    //获取抽奖状态
    public int getLuckDrawResult(String mobile, String luckDrawNum) {
        String redisKey = SweetConstant.REDIS_KEY_SWEET_LUCK_DRAW_RESULT.concat(luckDrawNum).concat(":mobile:" + mobile);
        Object obj = redisUtil.get(redisKey);
        if (obj == null) {
            return 0;
        } else {
            return (int) redisUtil.get(redisKey);
        }
    }

    //修改抽奖状态
    public SweetPrizeVo changeLuckDrawStatus(String mobile, String unionId, String luckDrawNum) {
        LinkedList<String> sqls = CollectionUtil.linkedListString();
        LinkedList<Object[]> sqlsDataA = CollectionUtil.linkedListObjectArr();
        LocalDateTime now = LocalDateTime.now();

        SweetPrizeVo vo = SweetPrizeVo.getNew();
        String redisKey = SweetConstant.REDIS_KEY_SWEET_LUCK_DRAW.concat(mobile).concat(":luckDrawNum:" + luckDrawNum);

        String redisSurplus = SweetConstant.REDIS_KEY_SWEET_LUCK_DRAW_SURPLUS.concat(luckDrawNum).concat(":surplus");
        String redisAll = SweetConstant.REDIS_KEY_SWEET_LUCK_DRAW_ALL.concat(luckDrawNum).concat(":all");
        String redisPresent = SweetConstant.REDIS_KEY_SWEET_LUCK_DRAW_PRESENT_MOBILE.concat(mobile);

        int surplus = (int) redisUtil.get(redisSurplus);//当前中奖数量
        int prize = 0;//总量
        int prizeALl = (int) redisUtil.get(redisAll);//不变的总量

        int count = (int) redisUtil.incr(redisKey, 1);
        if (count > 2) {
            vo.setPrize(prize);
            vo.setPrizeAll(prizeALl);
            return vo;
        }

        if (surplus < prizeALl) {
            //随机算法
            Object obj = redisUtil.get(redisPresent);
            int present;
            if (obj == null) {
                present = 10;
            } else {
                present = (int) obj;
            }
            int random1 = RandomUtil.getRandomIntTime(present, 101);
            int random2 = RandomUtil.getRandomIntTime(present, 101);
            if (random1 == random2) {
                surplus = (int) redisUtil.get(redisSurplus);
                if (surplus < prizeALl) {
                    prize = (int) redisUtil.incr(redisSurplus, 1);
                    redisUtil.set(redisKey, 2);
                    redisUtil.set(SweetConstant.REDIS_KEY_SWEET_LUCK_DRAW_RESULT.concat(luckDrawNum).concat(":mobile:" + mobile), prize);
                }
            }
        }

        sqls.add(SqlMapping.get("sweet_luck_draw.insert"));
        sqlsDataA.add(new Object[]{
                mobile, unionId, luckDrawNum, prize, prizeALl, now
        });
        queueUtils.sendMsgByRedis(MQConst.SweetQueue.LUCK_DRAW.getKey(),
                SqlMapping.gets(sqls, sqlsDataA));

        vo.setPrize(prize);
        vo.setPrizeAll(prizeALl);
        return vo;
    }

    // 答案
    public void setSweetAnswer(SweetAnswerVo sweetAnswerVo) {
        String redisKey = SweetConstant.REDIS_KEY_SWEET_ANSWER_PHONE.concat(sweetAnswerVo.getPhone());
        redisUtil.set(redisKey, sweetAnswerVo);
    }

    //草莓音乐节活动海报相关
    public void setSweetMusician(SweetStrawberryParam sweetStrawberry) {
        String redisKey = SweetConstant.REDIS_KEY_SWEET_STRAWBERRY_POSTER.concat(sweetStrawberry.getUnionId());
        redisUtil.set(redisKey, sweetStrawberry);
    }

    public SweetAnswerVo getSweetAnswer(String phone) {
        String redisKey = SweetConstant.REDIS_KEY_SWEET_ANSWER_PHONE.concat(phone);
        SweetAnswerVo sweetAnswerVo = (SweetAnswerVo) redisUtil.get(redisKey);
        return sweetAnswerVo;
    }

    // 投票
    public void setSweetCityVoteStatList(List<SweetCItyVoteStatVo> sweetCItyVoteStatVo, Integer type) {
        String redisKey = SweetConstant.REDIS_KEY_SWEET_CITY_VOTE.concat(String.valueOf(type))
                .concat(SweetConstant.REDIS_KEY_SWEET_CITY_VOTE_STAT_LIST);
        redisUtil.set(redisKey, sweetCItyVoteStatVo);
    }

    public List<SweetCItyVoteStatVo> getSweetCityVoteStatList(Integer type) {
        String redisKey = SweetConstant.REDIS_KEY_SWEET_CITY_VOTE.concat(String.valueOf(type))
                .concat(SweetConstant.REDIS_KEY_SWEET_CITY_VOTE_STAT_LIST);
        Object obj = redisUtil.get(redisKey);
        List<SweetCItyVoteStatVo> sweetCityVoteStatList = ObjectUtil.getSweetCItyVoteStatVoList();
        if (null != obj) {
            sweetCityVoteStatList = (List<SweetCItyVoteStatVo>) redisUtil.get(redisKey);
        }
        return sweetCityVoteStatList;
    }

    public void incrSweetCityVote(String cityCode, Integer type) {
        String redisKey = SweetConstant.REDIS_KEY_SWEET_CITY_VOTE.concat(String.valueOf(type))
                .concat(SweetConstant.REDIS_KEY_SWEET_CITY_VOTE_CITY_CODE).concat(cityCode);
        redisUtil.incr(redisKey, 1);
    }

    public Integer getSweetCityVote(String cityCode, Integer type) {
        String redisKey = SweetConstant.REDIS_KEY_SWEET_CITY_VOTE.concat(String.valueOf(type))
                .concat(SweetConstant.REDIS_KEY_SWEET_CITY_VOTE_CITY_CODE).concat(cityCode);
        Object obj = redisUtil.get(redisKey);
        if (null == obj) {
            return 0;
        } else {
            return (Integer) obj;
        }
    }

    public void setUserVote(String phone, String openId, SweetCityVoteParam param) {
        String redisKey = SweetConstant.REDIS_KEY_SWEET_CITY_VOTE.concat(String.valueOf(param.getType()))
                .concat(SweetConstant.REDIS_KEY_SWEET_CITY_VOTE_USER).concat(phone).concat("-").concat(openId);
        redisUtil.set(redisKey, param);
    }

    public SweetCityVoteParam getUserVote(String phone, String openId, Integer type) {
        String redisKey = SweetConstant.REDIS_KEY_SWEET_CITY_VOTE.concat(String.valueOf(type))
                .concat(SweetConstant.REDIS_KEY_SWEET_CITY_VOTE_USER).concat(phone).concat("-").concat(openId);
        Object obj = redisUtil.get(redisKey);
        if (null == obj) {
            return null;
        } else {
            return (SweetCityVoteParam) obj;
        }
    }

    public void setSweetCityVoteStatUpdateTime(Integer type) {
        String redisKey = SweetConstant.REDIS_KEY_SWEET_CITY_VOTE.concat(String.valueOf(type))
                .concat(SweetConstant.REDIS_KEY_SWEET_CITY_VOTE_STAT_UPDATE_TIME);
        redisUtil.set(redisKey, DateUtil.getNowTime());
    }

    public String getSweetCityVoteStatUpdateTime(Integer type) {
        String redisKey = SweetConstant.REDIS_KEY_SWEET_CITY_VOTE.concat(String.valueOf(type))
                .concat(SweetConstant.REDIS_KEY_SWEET_CITY_VOTE_STAT_UPDATE_TIME);
        Object obj = redisUtil.get(redisKey);
        if (null == obj) {
            return "";
        } else {
            return (String) obj;
        }
    }

    // 积分抽奖活动
    public List<IntegralActivityVo> getIntegralActivityList() {
        String redisKey = SweetConstant.REDIS_KEY_SWEET_INTEGRAL_ACTIVITY_LIST;
        Object obj = redisUtil.get(redisKey);
        if (null == obj) {
            return ObjectUtil.getSweetIntegralActivityVoList();
        } else {
            return (List<IntegralActivityVo>) obj;
        }
    }

    public IntegralActivityVo getIntegralActivityInfo(String integralActivityId) {
        String redisKey = SweetConstant.REDIS_KEY_SWEET_INTEGRAL_ACTIVITY_INFO.concat(integralActivityId);
        Object obj = redisUtil.get(redisKey);
        if (null == obj) {
            return null;
        } else {
            return (IntegralActivityVo) obj;
        }
    }

    public void setIntegralActivityDraw(IntegralActivityDrawVo integralActivityDrawVo) {
        String userId = integralActivityDrawVo.getUserId();
        String integralActivityId = integralActivityDrawVo.getIntegralActivityId();

        this.delIntegralActivityDrawList(userId, integralActivityId);

        // 抽奖详情
        String redisKeyDraw = SweetConstant.REDIS_KEY_SWEET_INTEGRAL_ACTIVITY_DRAW_INFO
                .concat(integralActivityDrawVo.getDrawId());
        redisUtil.set(redisKeyDraw, integralActivityDrawVo);
    }

    public LinkedList<IntegralActivityDrawVo> getIntegralActivityDrawAll(String integralActivityId) {
        String redisKey = SweetConstant.REDIS_KEY_SWEET_INTEGRAL_ACTIVITY_DRAW_ALL_LIST
                .concat(integralActivityId);
        Object obj = redisUtil.get(redisKey);
        if (null == obj) {
            return SweetNewObjectUtil.getSweetIntegralActivityDrawVoLinkedList();
        } else {
            List<IntegralActivityDrawVo> integralActivityDrawVos = (List<IntegralActivityDrawVo>) obj;
            LinkedList<IntegralActivityDrawVo> collect = integralActivityDrawVos.stream().collect(Collectors.toCollection(LinkedList::new));
            return collect;
        }
    }

    public void setIntegralActivityDrawAll(String integralActivityId, List<SweetIntegralActivityDraw> sweetIntegralActivityDraws) {
        String redisKey = SweetConstant.REDIS_KEY_SWEET_INTEGRAL_ACTIVITY_DRAW_ALL_LIST
                .concat(integralActivityId);
        redisUtil.set(redisKey, sweetIntegralActivityDraws);
    }

    public LinkedList<IntegralActivityDrawVo> getIntegralActivityDrawList(String uid, String integralActivityId) {
        String redisKey = SweetConstant.REDIS_KEY_SWEET_INTEGRAL_ACTIVITY_DRAW_IN_USER
                .concat(integralActivityId)
                .concat(SweetConstant.REDIS_KEY_SWEET_INTEGRAL_ACTIVITY_DRAW_USER_KEY)
                .concat(uid);
        Object obj = redisUtil.get(redisKey);
        if (null == obj) {
            return null;
        } else {
            return (LinkedList<IntegralActivityDrawVo>) obj;
        }
    }

    public void setIntegralActivityDrawList(String uid, String integralActivityId, List<IntegralActivityDrawVo> integralActivityDrawVos) {
        List<IntegralActivityDrawVo> myList = integralActivityDrawVos.stream().collect(Collectors.toCollection(LinkedList::new));
        String redisKey = SweetConstant.REDIS_KEY_SWEET_INTEGRAL_ACTIVITY_DRAW_IN_USER
                .concat(integralActivityId)
                .concat(SweetConstant.REDIS_KEY_SWEET_INTEGRAL_ACTIVITY_DRAW_USER_KEY)
                .concat(uid);
        redisUtil.set(redisKey, myList);
    }

    public void delIntegralActivityDrawList(String uid, String integralActivityId) {
        String redisKey = SweetConstant.REDIS_KEY_SWEET_INTEGRAL_ACTIVITY_DRAW_IN_USER
                .concat(integralActivityId)
                .concat(SweetConstant.REDIS_KEY_SWEET_INTEGRAL_ACTIVITY_DRAW_USER_KEY)
                .concat(uid);
        redisUtil.del(redisKey);
    }

    public int getIntegralActivityPrizeNum(String integralActivityId, String prizeId) {
        String redisKey = SweetConstant.REDIS_KEY_SWEET_INTEGRAL_ACTIVITY_PRIZE_NUM
                .concat(integralActivityId)
                .concat(SweetConstant.REDIS_KEY_SWEET_INTEGRAL_ACTIVITY_PRIZE_ID)
                .concat(prizeId);
        Object obj = redisUtil.get(redisKey);
        if (null == obj) {
            return 0;
        } else {
            return (int) obj;
        }
    }

    public long decrIntegralActivityPrizeNum(String integralActivityId, String prizeId, int num) {
        String redisKey = SweetConstant.REDIS_KEY_SWEET_INTEGRAL_ACTIVITY_PRIZE_NUM
                .concat(integralActivityId)
                .concat(SweetConstant.REDIS_KEY_SWEET_INTEGRAL_ACTIVITY_PRIZE_ID)
                .concat(prizeId);
        long decr = redisUtil.decr(redisKey, num);
        return decr;
    }

    public long incrIntegralActivityPrizeNum(String integralActivityId, String prizeId, Integer num) {
        String redisKey = SweetConstant.REDIS_KEY_SWEET_INTEGRAL_ACTIVITY_PRIZE_NUM
                .concat(integralActivityId)
                .concat(SweetConstant.REDIS_KEY_SWEET_INTEGRAL_ACTIVITY_PRIZE_ID)
                .concat(prizeId);
        return redisUtil.incr(redisKey, num);
    }

    public int getIntegralActivityTotalPrizeNum(String integralActivityId) {
        String redisKey = SweetConstant.REDIS_KEY_SWEET_INTEGRAL_ACTIVITY_TOTAL_PRIZE_NUM
                .concat(integralActivityId);
        Object obj = redisUtil.get(redisKey);
        if (null == obj) {
            return 0;
        } else {
            return (int) obj;
        }
    }

    public long decrIntegralActivityTotalPrizeNum(String integralActivityId) {
        String redisKey = SweetConstant.REDIS_KEY_SWEET_INTEGRAL_ACTIVITY_TOTAL_PRIZE_NUM
                .concat(integralActivityId);
        long decr = redisUtil.decr(redisKey, 1);
        return decr;
    }

    public IntegralActivityDrawVo getIntegralActivityDrawInfo(String drawId) {
        String redisKeyDraw = SweetConstant.REDIS_KEY_SWEET_INTEGRAL_ACTIVITY_DRAW_INFO
                .concat(drawId);
        Object obj = redisUtil.get(redisKeyDraw);
        if (null == obj) {
            return IntegralActivityDrawVo.getNew();
        } else {
            return (IntegralActivityDrawVo) obj;
        }
    }

    public void setIntegralActivityDrawInfo(String drawId, IntegralActivityDrawVo drawVo) {
        String redisKeyDraw = SweetConstant.REDIS_KEY_SWEET_INTEGRAL_ACTIVITY_DRAW_INFO
                .concat(drawId);
        redisUtil.set(redisKeyDraw, drawVo);
    }

    public void updateIntegralActivityDrawInfo(String drawId, String couponId) {
        String redisKeyDraw = SweetConstant.REDIS_KEY_SWEET_INTEGRAL_ACTIVITY_DRAW_INFO
                .concat(drawId);
        IntegralActivityDrawVo info = (IntegralActivityDrawVo) redisUtil.get(redisKeyDraw);
        info.setReceivingStatus(2);
        info.setRelationId(couponId);
        info.setUpdatedAt(LocalDateTime.now());
        redisUtil.set(redisKeyDraw, info);
    }

    public void setIntegralActivityDrawBlack(List<String> uidS) {
        String redisKey = SweetConstant.REDIS_KEY_SWEET_INTEGRAL_ACTIVITY_DRAW_BLACK;
        redisUtil.set(redisKey, uidS);
    }

    public List<String> getIntegralActivityDrawBlack() {
        String redisKey = SweetConstant.REDIS_KEY_SWEET_INTEGRAL_ACTIVITY_DRAW_BLACK;
        Object obj = redisUtil.get(redisKey);
        if (null == obj) {
            return Arrays.asList();
        } else {
            return (List<String>) obj;
        }
    }

    public void setIntegralActivityDrawWhite(List<String> uidS) {
        String redisKey = SweetConstant.REDIS_KEY_SWEET_INTEGRAL_ACTIVITY_DRAW_WHITE;
        redisUtil.set(redisKey, uidS);
    }

    public List<String> getIntegralActivityDrawWhite() {
        String redisKey = SweetConstant.REDIS_KEY_SWEET_INTEGRAL_ACTIVITY_DRAW_WHITE;
        Object obj = redisUtil.get(redisKey);
        if (null == obj) {
            return Arrays.asList();
        } else {
            return (List<String>) obj;
        }
    }

    public boolean setIntegralDrawLock(String userId) {
        String redisKey = SweetConstant.REDIS_KEY_SWEET_INTEGRAL_ACTIVITY_LOCK
                .concat(userId);
        return redisUtil.lock(redisKey, 1, 60);
    }

    public void delIntegralDrawLock(String userId) {
        String redisKey = SweetConstant.REDIS_KEY_SWEET_INTEGRAL_ACTIVITY_LOCK
                .concat(userId);
        redisUtil.uLock(redisKey);
    }

    /***
     * 设置活动开始结束时间
     * @param type
     * @param startTime
     * @param endTime
     */
    public void setStartEndTime(Integer type, String startTime, String endTime) {
        String startRedisKey = SweetConstant.REDIS_KEY_SWEET_CITY_VOTE_START.concat(":type:" + type);
        String endRedisKey = SweetConstant.REDIS_KEY_SWEET_CITY_VOTE_END.concat(":type:" + type);
        redisUtil.set(startRedisKey, startTime);
        redisUtil.set(endRedisKey, endTime);
    }

    /**
     * 获取活动开始结束时间 如果报错返回null
     *
     * @param type
     * @return
     */
    public HashMap<String, String> getStartEndTime(Integer type) {
        try {
            HashMap<String, String> map = CollectionUtil.mapStringString();
            String startRedisKey = SweetConstant.REDIS_KEY_SWEET_CITY_VOTE_START.concat(":type:" + type);
            String endRedisKey = SweetConstant.REDIS_KEY_SWEET_CITY_VOTE_END.concat(":type:" + type);
            map.put("startTime", (String) redisUtil.get(startRedisKey));
            map.put("endTime", (String) redisUtil.get(endRedisKey));
            return map;
        } catch (Exception e) {
            return null;
        }
    }


    /**
     * 设置临时banner
     *
     * @param type
     * @param vo
     */
    public void setTempBanner(Integer type, List<TempBannerVo> vo) {
        String redisKey = SweetConstant.REDIS_KEY_SWEET_CITY_VOTE_BANNER.concat(":type:" + type);
        redisUtil.set(redisKey, vo);
    }

    /**
     * 获取临时banner
     *
     * @param type
     * @return
     */
    public List<TempBannerVo> getTempBanner(Integer type) {
        String redisKey = SweetConstant.REDIS_KEY_SWEET_CITY_VOTE_BANNER.concat(":type:" + type);
        Object obj = redisUtil.get(redisKey);
        if (obj == null) {
            return null;
        } else {
            return (List<TempBannerVo>) obj;
        }
    }

    public int getIntegralActivityEstimatedNum(String integralActivityId) {
        String redisKey = SweetConstant.REDIS_KEY_SWEET_INTEGRAL_ACTIVITY_ESTIMATEDNUM
                .concat(integralActivityId);
        Object obj = redisUtil.get(redisKey);
        if (null == obj) {
            return 0;
        } else {
            return (int) obj;
        }
    }

    public void decrIntegralActivityEstimatedNum(String integralActivityId, Integer num) {
        String redisKey = SweetConstant.REDIS_KEY_SWEET_INTEGRAL_ACTIVITY_ESTIMATEDNUM
                .concat(integralActivityId);
        redisUtil.decr(redisKey, num);
    }

    public void setSendCoupon(String drawId,int value) {
        String redisKey = SweetConstant.REDIS_KEY_SWEET_SEND_COUPON.concat(drawId);
        redisUtil.set(redisKey, 0);
    }

    public boolean isSendCoupon(String drawId) {
        String redisKey = SweetConstant.REDIS_KEY_SWEET_SEND_COUPON.concat(drawId);
        return redisUtil.hasKey(redisKey);
    }
}
