package com.liquidnet.service.adam.dto.vo;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.liquidnet.commons.lang.util.DateUtil;
import com.liquidnet.service.adam.entity.AdamMemberCode;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.time.LocalDateTime;

@ApiModel(value = "AdamMemberCodeAdminVo", description = "会员码兑换")
@Data
public class AdamMemberCodeVo implements Serializable, Cloneable {
    private static final long serialVersionUID = -2822442493419088086L;
    @ApiModelProperty(position = 0, value = "会员码")
    private String code;
    @ApiModelProperty(position = 1, value = "会员类型id")
    private String memberId;
    @ApiModelProperty(position = 2, value = "会员价格id")
    private String memberPriceId;
    @ApiModelProperty(position = 3, value = "类型:1-购买,2-赠送(后台生成)")
    private Integer type;
    @ApiModelProperty(position = 4, value = "会员编号")
    private String memberNo;
    @ApiModelProperty(position = 5, value = "状态[0-可用|1-已用|2-无效|3-过期｜4-失效｜5-退回]")
    private Integer state;
    @ApiModelProperty(position = 6, value = "有效期（单位天）")
    @JsonFormat(shape=JsonFormat.Shape.STRING, pattern= DateUtil.DATE_FULL_STR)
    private Integer validity;
    @ApiModelProperty(position = 7, value = "生效时间")
    @JsonFormat(shape=JsonFormat.Shape.STRING, pattern= DateUtil.DATE_FULL_STR)
    private LocalDateTime effectAt;
    @ApiModelProperty(position = 8, value = "失效时间")
    @JsonFormat(shape=JsonFormat.Shape.STRING, pattern= DateUtil.DATE_FULL_STR)
    private LocalDateTime expireAt;
    @ApiModelProperty(position = 9, value = "操作人")
    private String operator;
    @JsonFormat(shape=JsonFormat.Shape.STRING, pattern= DateUtil.DATE_FULL_STR)
    private LocalDateTime createdAt;
    @JsonFormat(shape=JsonFormat.Shape.STRING, pattern= DateUtil.DATE_FULL_STR)
    private LocalDateTime updatedAt;
    @ApiModelProperty(position = 11, value = "购买会员码的订单编号")
    private String buyOrderNo;
    @ApiModelProperty(position = 12, value = "购买会员码的用户id")
    private String buyUid;
    @ApiModelProperty(position = 13, value = "购买时间")
    @JsonFormat(shape=JsonFormat.Shape.STRING, pattern= DateUtil.DATE_FULL_STR)
    private LocalDateTime buyAt;
    @ApiModelProperty(position = 14, value = "使用会员码的订单编号")
    private String useOrderNo;
    @ApiModelProperty(position = 15, value = "使用会员码的用户id")
    private String useUid;
    @ApiModelProperty(position = 16, value = "使用时间")
    @JsonFormat(shape=JsonFormat.Shape.STRING, pattern= DateUtil.DATE_FULL_STR)
    private LocalDateTime useAt;

    private static final AdamMemberCodeVo obj = new AdamMemberCodeVo();

    public static AdamMemberCodeVo getNew() {
        try {
            return (AdamMemberCodeVo) obj.clone();
        } catch (CloneNotSupportedException e) {
            return new AdamMemberCodeVo();
        }
    }

    public AdamMemberCodeVo copy(AdamMemberCode source) {
        if (null == source) return this;
        this.setCode(source.getCode());
        this.setMemberId(source.getMemberId());
        this.setMemberPriceId(source.getMemberPriceId());
        this.setType(source.getType());
        this.setMemberNo(source.getMemberNo());
        this.setState(source.getState());
        this.setValidity(source.getValidity());
        this.setEffectAt(source.getEffectAt());
        this.setExpireAt(source.getExpireAt());
        this.setCreatedAt(source.getCreatedAt());
        this.setUpdatedAt(source.getUpdatedAt());
        this.setBuyOrderNo(source.getBuyOrderNo());
        this.setBuyUid(source.getBuyUid());
        this.setBuyAt(source.getBuyAt());
        this.setUseOrderNo(source.getUseOrderNo());
        this.setUseUid(source.getUseUid());
        this.setUseAt(source.getUseAt());
        return this;
    }
}
