package com.liquidnet.service.goblin.service;

import com.github.pagehelper.PageInfo;
import com.liquidnet.service.base.ResponseDto;
import com.liquidnet.service.goblin.dto.vo.*;
import com.liquidnet.service.goblin.param.GoblinAppOrderRefundParam;

import javax.servlet.http.HttpServletRequest;
import java.util.List;

public interface IGoblinOrderAppService {

    ResponseDto<PageInfo<GoblinAppOrderListVo>> orderList(int page, String pre);

    ResponseDto<List<GoblinAppOrderListVo>> orderListByMaster(String orderMasterCode);

    ResponseDto<GoblinAppOrderDetailsVo> orderDetails(String orderId,String uid);

    ResponseDto<Boolean> getProduce(String orderId,String uid);

    ResponseDto<Boolean> applyRefund(GoblinAppOrderRefundParam param);

    ResponseDto<Boolean> againRefund(GoblinAppOrderRefundParam param);

    ResponseDto<List<GoblinBackOrderVo>> refundDetails(String orderId);

    String huiFuSync(HttpServletRequest request);

    ResponseDto<List<GoblinMailVo>> getMail(String orderId, String mailId);
}
