package com.liquidnet.service.service.impl;

import com.liquidnet.common.cache.redis.util.RedisUtil;
import com.liquidnet.commons.lang.util.StringUtil;
import com.liquidnet.service.goblin.constant.SmileRedisConst;
import com.liquidnet.service.goblin.dto.vo.SmileUserVO;
import com.liquidnet.service.goblin.service.manage.SmileFrontService;
import com.liquidnet.service.kylin.dto.vo.mongo.KylinPerformanceVo;
import com.liquidnet.service.util.ObjectUtil;
import com.liquidnet.service.util.SmileMongoUtils;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;

@Service
@Slf4j
public class SmileFrontServiceImpl implements SmileFrontService {
    @Autowired
    private RedisUtil redisUtil;
    @Autowired
    private SmileMongoUtils smileMongoUtils;
    public boolean saveOrUpdateUser(SmileUserVO smileUserVO,SmileUserVO redisVo,String type){
        //redis里面更新
        if(null==redisVo){
            smileUserVO.setCreatedDate(LocalDateTime.now());
            smileUserVO.setDelTag(0);
            redisUtil.set(SmileRedisConst.SMILE_USER.concat(smileUserVO.getUid()),smileUserVO);
            //插入
        }else{
            //update
            setUser(smileUserVO,redisVo,type);
            redisUtil.set(SmileRedisConst.SMILE_USER.concat(redisVo.getUid()),redisVo);
        }
        return true;
    }
    public List<KylinPerformanceVo>  getPerformance(){
        ArrayList<KylinPerformanceVo> list= ObjectUtil.kylinPerformanceVoList();
        String perforManceIds= (String) redisUtil.get(SmileRedisConst.SMILE_SHOW);
        if(StringUtil.isNotBlank(perforManceIds)){
            for(String id:perforManceIds.split(",")){
                KylinPerformanceVo kylinPerformanceVo=smileMongoUtils.getPerFormance(id);
                if(null!=kylinPerformanceVo){
                    list.add(kylinPerformanceVo);
                }
            }
        }
        return list;
    }
    public void setUser(SmileUserVO smileUserVO,SmileUserVO redisVo,String type){
        if(type.equals("1")){
            redisVo.setImg(smileUserVO.getImg());
            redisVo.setSex(smileUserVO.getSex());
            redisVo.setProvinceKey(smileUserVO.getProvinceKey());
            redisVo.setProvince(smileUserVO.getProvince());
            redisVo.setCity(smileUserVO.getCity());
            redisVo.setCityKey(smileUserVO.getCityKey());
            redisVo.setArea(smileUserVO.getArea());
            redisVo.setAreaKey(smileUserVO.getAreaKey());
            redisVo.setAddress(smileUserVO.getAddress());
            redisVo.setWechat(smileUserVO.getWechat());
            redisVo.setSchoolName(smileUserVO.getSchoolName());
            redisVo.setSchoolMajor(smileUserVO.getSchoolMajor());
            redisVo.setIdentity(smileUserVO.getIdentity());
            redisVo.setTag(smileUserVO.getTag());
            redisVo.setUpdatedDate(LocalDateTime.now());
            redisVo.setUid(smileUserVO.getUid());
            redisVo.setDelTag(0);
        }else if (type.equals("2")){
            redisVo.setName(smileUserVO.getName());
            redisVo.setIdCard(smileUserVO.getIdCard());
            redisVo.setUpdatedDate(LocalDateTime.now());
            redisVo.setUid(smileUserVO.getUid());
            redisVo.setDelTag(0);
        }else if(type.equals("3")){
            redisVo.setIntroduce(smileUserVO.getIntroduce());
            redisVo.setSpecialty1(smileUserVO.getSpecialty1());
            redisVo.setSpecialty2(smileUserVO.getSpecialty2());
            redisVo.setSpecialty3(smileUserVO.getSpecialty2());
            redisVo.setUpdatedDate(LocalDateTime.now());
            redisVo.setUid(smileUserVO.getUid());
            redisVo.setDelTag(0);
        }
    }


}
