package com.liquidnet.client.admin.web.controller.wallet;

import com.liquidnet.client.admin.common.core.controller.BaseController;
import com.liquidnet.client.admin.common.core.page.PageDomain;
import com.liquidnet.client.admin.common.core.page.TableDataInfo;
import com.liquidnet.client.admin.common.core.page.TableSupport;
import com.liquidnet.client.admin.common.utils.StringUtils;
import com.liquidnet.service.account.wallet.dto.WalletQueryParam;
import com.liquidnet.service.account.wallet.dto.WalletQueryResult;
import com.liquidnet.service.feign.account.api.FeignAccountClient;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.temporal.ChronoField;
import java.util.ArrayList;

/**
 * WalletAccountController.class
 *
 * @author zhanggb
 * Created by IntelliJ IDEA at 2020/11/6
 */
@Controller
@RequestMapping("wallet/information")
public class WalletAccountController extends BaseController {
    final DateTimeFormatter formatter = new DateTimeFormatterBuilder()
            .appendPattern("yyyy-MM-dd[['T'HH][:mm][:ss]]")
            .parseDefaulting(ChronoField.HOUR_OF_DAY, 0)
            .parseDefaulting(ChronoField.MINUTE_OF_HOUR, 0)
            .parseDefaulting(ChronoField.SECOND_OF_MINUTE, 0)
            .parseDefaulting(ChronoField.MILLI_OF_SECOND, 0).toFormatter();
    private String prefix = "wallet/information";

    @Autowired
    private FeignAccountClient accountClient;

    @GetMapping()
    public String wallet() {
        return prefix;
    }

    @PostMapping("list")
    @ResponseBody
    public TableDataInfo list(WalletQueryParam param) {
        WalletQueryResult walletQueryResult = null;
        try {
            PageDomain pageDomain = TableSupport.buildPageRequest();
            param.setChannelId("50001");
            param.setBizType("000");
            param.setPageNum(pageDomain.getPageNum());
            param.setPageSize(pageDomain.getPageSize());
            String startTimeStr = getRequest().getParameter("startTimeStr");
            String endTimeStr = getRequest().getParameter("endTimeStr");
            LocalDateTime startTime = null, endTime = null;
            if (StringUtils.isNotEmpty(startTimeStr)) {
                startTime = LocalDateTime.parse(startTimeStr, formatter);
            }
            if (StringUtils.isNotEmpty(endTimeStr)) {
                endTime = LocalDateTime.parse(endTimeStr, formatter);
            }
            param.setStartTime(startTime);
            param.setEndTime(endTime);

            walletQueryResult = accountClient.query(param);
        } catch (Exception e) {
            logger.error("err:wallet/information/list", e);
        }
        return null == walletQueryResult || !walletQueryResult.isSuccess() ? getDataTable(new ArrayList<>())
                : getDataTable(walletQueryResult.getPageInfo().getList(), walletQueryResult.getPageInfo().getTotal());
    }
}
