package com.liquidnet.service.adam.service.impl;

import com.liquidnet.common.cache.redis.util.RedisUtil;
import com.liquidnet.commons.lang.util.DateUtil;
import com.liquidnet.service.adam.constant.AdamRedisConst;
import com.liquidnet.service.adam.dto.vo.AdamCollectionVo;
import com.liquidnet.service.adam.entity.AdamCollection;
import com.liquidnet.service.adam.mapper.AdamCollectionMapper;
import com.liquidnet.service.adam.service.IAdamCollectionService;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import org.springframework.amqp.rabbit.core.RabbitTemplate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.convert.MongoConverter;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.stereotype.Service;

import java.time.LocalDateTime;

/**
 * <p>
 * 收藏 服务实现类
 * </p>
 *
 * @author liquidnet
 * @since 2021-05-10
 */
@Service
public class AdamCollectionServiceImpl extends ServiceImpl<AdamCollectionMapper, AdamCollection> implements IAdamCollectionService {
    @Autowired
    MongoConverter mongoConverter;
    @Autowired
    MongoTemplate mongoTemplate;
    @Autowired
    RabbitTemplate rabbitTemplate;
    @Autowired
    RedisUtil redisUtil;

    @Override
    public void add(AdamCollectionVo collectionVo) {
        LocalDateTime now = LocalDateTime.now();
        String nowStr = DateUtil.format(now, DateUtil.Formatter.yyyyMMddHHmmss);


    }

    @Override
    public AdamCollectionVo query(String uid, String type, String contentId) {
        AdamCollectionVo vo = (AdamCollectionVo) redisUtil.hget(AdamRedisConst.INFO_COLLECT.concat(uid), type + contentId);
        if (null == vo) {
            vo = mongoTemplate.findOne(Query.query(Criteria.where("uid").is(uid).and("type").is(type).and("contentId").is(contentId)),
                    AdamCollectionVo.class, AdamCollectionVo.class.getSimpleName());

            if (null != vo) {
                redisUtil.hset(AdamRedisConst.INFO_COLLECT.concat(uid), type + contentId, vo);
            }
        }
        return vo;
    }
}
