package com.liquidnet.service.adam.service.impl;

import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.liquidnet.common.cache.redis.util.RedisUtil;
import com.liquidnet.service.adam.dto.AdamMemberOrderCodeParam;
import com.liquidnet.service.adam.dto.AdamMemberOrderParam;
import com.liquidnet.service.adam.dto.AdamMemberOrderResult;
import com.liquidnet.service.adam.dto.vo.AdamMemberOrderVo;
import com.liquidnet.service.adam.dto.vo.AdamMemberPriceVo;
import com.liquidnet.service.adam.dto.vo.AdamMemberVo;
import com.liquidnet.service.adam.entity.AdamMemberOrder;
import com.liquidnet.service.adam.mapper.AdamMemberOrderMapper;
import com.liquidnet.service.adam.mapper.AdamMemberPriceMapper;
import com.liquidnet.service.adam.service.IAdamMemberOrderService;
import com.liquidnet.service.adam.service.IAdamMemberService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.amqp.rabbit.core.RabbitTemplate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.convert.MongoConverter;
import org.springframework.stereotype.Service;

import java.util.List;

@Slf4j
@Service
public class AdamMemberOrderServiceImpl extends ServiceImpl<AdamMemberOrderMapper, AdamMemberOrder> implements IAdamMemberOrderService {

    @Autowired
    AdamMemberOrderMapper adamMemberOrderMapper;
    @Autowired
    AdamMemberPriceMapper adamMemberPriceMapper;
    @Autowired
    MongoTemplate mongoTemplate;
    @Autowired
    MongoConverter mongoConverter;
    @Autowired
    RabbitTemplate rabbitTemplate;
    @Autowired
    RedisUtil redisUtil;
    @Autowired
    IAdamMemberService adamMemberService;

    @Override
    public AdamMemberOrderResult buyMemberOrMemberCode(AdamMemberOrderParam param) throws Exception {
        AdamMemberOrderResult result = new AdamMemberOrderResult();
        // 判断黑名单，待定（暂不做）

        // 验证会员是否有效
        AdamMemberVo adamMemberVo = adamMemberService.queryMemberInfo();
        if (adamMemberVo.getMemberId() != param.getMemberId()) {
            result.setState(0);
            return result;
        }
        // 验证价格是否有效
        List<AdamMemberPriceVo> adamMemberPrice = adamMemberVo.getAdamMemberPrice();
        for (int i = 0; i < adamMemberPrice.size(); i++) {
            AdamMemberPriceVo adamMemberPriceVo = adamMemberPrice.get(i);
            if (adamMemberPriceVo.getMemberPriceId().equals(param.getMemberPriceId())) {

            }
        }
        // 获取会员编号

        // 生成订单信息

        int buyType = param.getMode();
        // 判断购买情况
        // 调取对应支付接口
        String a = "";
        switch (buyType) {
            case 0:
                a = "1";
                break;
            case 1:
                a = "2";
                break;
            default:
                a = "3";
                break;
        }
        return result;
    }

    /**
     * 使用会员码
     *
     * @param param
     * @return
     */
    @Override
    public Object useMemberCode(AdamMemberOrderCodeParam param) {
        String uid = param.getUid();
        String code = param.getMemberCode();
        return null;
    }

    /**
     * 购买会员
     *
     * @return
     */
    private Object buyMember() {
        return null;
    }

    /**
     * 购买会员码
     *
     * @return
     */
    private Object buyMemberCode() {
        return null;
    }

    @Override
    public AdamMemberOrderVo getMemberOrderInfo(String orderNo) {
        return null;
    }
}
