package com.liquidnet.service.kylin.dto.vo;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.datatype.jsr310.deser.LocalDateTimeDeserializer;
import com.fasterxml.jackson.datatype.jsr310.ser.LocalDateTimeSerializer;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.io.Serializable;
import java.time.LocalDateTime;

//返回

@Data
public class FieldsVo implements Serializable {
    @ApiModelProperty(value = "主键id")
    private String fieldsId;

    @ApiModelProperty(value = "场地名称")
    private String name;

    @ApiModelProperty(value = "英文名")
    private String nameEng;

    @ApiModelProperty(value = "拼音")
    private String pinyin;

    @ApiModelProperty(value = "封面图")
    private String coverImg;

    @ApiModelProperty(value = "详细地址")
    private String address;

    @ApiModelProperty(value = "经度")
    private String longitude;

    @ApiModelProperty(value = "纬度")
    private String latitude;

    @ApiModelProperty(value = "联系电话")
    private String phone;

    @ApiModelProperty(value = "描述")
    private String description;

    @ApiModelProperty(value = "省id")
    private Integer provinceId;

    @ApiModelProperty(value = "省名称")
    private String provinceName;

    @ApiModelProperty(value = "城市id")
    private Integer cityId;

    @ApiModelProperty(value = "城市名称")
    private String cityName;

    @ApiModelProperty(value = "县id")
    private Integer districtId;

    @ApiModelProperty(value = "县名称")
    private String districtName;

    @ApiModelProperty(value = "拒绝理由")
    private String refuseMessage;

    @ApiModelProperty(value = "认证状态 0未认证 1已认证")
    private Integer validStatus;

    @ApiModelProperty(value = "是否显示 0不显示 1显示")
    private Integer isDisplay;

    @ApiModelProperty(value = "是否营业 0不营业 1营业中")
    private Integer isBusiness;

    @ApiModelProperty(value = "审核状态 0待审核 1已审核 2被拒绝")
    private Integer changeStatus;

    @ApiModelProperty(value = "补充字段")
    private String comment;

    @ApiModelProperty(value = "创建时间")
    private String  createdAt;

    @ApiModelProperty(value = "修改时间")
    private String updatedAt;
}
