package com.liquidnet.service.kylin.entity;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import java.time.LocalDateTime;
import java.io.Serializable;
import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * <p>
 * 场地状态
 * </p>
 *
 * @author liquidnet
 * @since 2021-04-29
 */
@Data
@EqualsAndHashCode(callSuper = false)
public class KylinFieldStatus implements Serializable {

    private static final long serialVersionUID = 1L;

    @TableId(value = "mid", type = IdType.AUTO)
    private Integer mid;

    /**
     * field_status_id
     */
    private String fieldStatusId;

    /**
     * 场地关联id
     */
    private String fieldId;

    /**
     * 认证状态 0未认证 1已认证
     */
    private Integer validStatus;

    /**
     * 是否显示 0不显示 1显示
     */
    private Integer isDisplay;

    /**
     * 是否营业 0不营业 1营业中
     */
    private Integer isBusiness;

    /**
     * 审核状态 0待审核 1已审核 2被拒绝
     */
    private Integer changeStatus;

    /**
     * 创建时间
     */
    private LocalDateTime createdAt;

    /**
     * 修改时间
     */
    private LocalDateTime updatedAt;


}
