package com.liquidnet.service.consumer.base.receiver.sweet;

import com.liquidnet.commons.lang.util.CollectionUtil;
import com.liquidnet.commons.lang.util.JsonUtils;
import com.liquidnet.service.base.constant.MQConst;
import com.liquidnet.service.consumer.base.receiver.AbstractBizRedisReceiver;
import com.liquidnet.service.consumer.base.service.impl.sweet.SweetWechatTemplateMsgServiceImpl;
import com.liquidnet.service.sweet.dto.param.SweetOpenSendMsgParam;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.connection.stream.MapRecord;
import org.springframework.data.redis.connection.stream.StreamRecords;
import org.springframework.stereotype.Component;

import java.util.HashMap;

@Slf4j
@Component
public class ConsumerSweetTemplateMsgReceiver extends AbstractBizRedisReceiver {

    @Autowired
    SweetWechatTemplateMsgServiceImpl sweetWechatTemplateService;

    @Override
    protected String getRedisStreamKey() {
        return MQConst.SweetQueue.SWEET_TEMPLATE_MSG.getKey();
    }

    @Override
    protected String getRedisStreamGroup() {
        return MQConst.SweetQueue.SWEET_TEMPLATE_MSG.getGroup();
    }

    /*@Override
    public void onMessage(MapRecord<String, String, String> message) {
        String redisStreamKey = this.getRedisStreamKey();
        log.debug("CONSUMER MSG[streamKey:{},messageId:{},stream:{},body:{}]", redisStreamKey, message.getId(), message.getStream(), message.getValue());
        boolean result = this.consumerMessageHandler(message.getValue().get("message"));
        log.info("CONSUMER MSG RESULT:{} ==> [{}]MESSAGE_ID:{}", result, redisStreamKey, message.getId());

        try {
            stringRedisTemplate.opsForStream().acknowledge(getRedisStreamGroup(), message);
        } catch (Exception e) {
            log.error("#CONSUMER MSG EX_ACK ==> [{}]RESULT:{},MESSAGE:{}", redisStreamKey, result, message.getValue(), e);
        }
        try {
            stringRedisTemplate.opsForStream().delete(redisStreamKey, message.getId());
        } catch (Exception e) {
            log.error("#CONSUMER MSG EX_DEL ==> [{}]RESULT:{},MESSAGE:{}", redisStreamKey, result, message.getValue(), e);
        }
    }*/

    protected boolean consumerMessageHandler(String msg) {
        boolean aBoolean = false;
        try {
            SweetOpenSendMsgParam sweetOpenSendMsgParam = JsonUtils.fromJson(msg, SweetOpenSendMsgParam.class);
            aBoolean = null == sweetOpenSendMsgParam || sweetWechatTemplateService.openSendMsg(sweetOpenSendMsgParam);
        } catch (Exception e) {
            log.error("CONSUMER MSG EX_HANDLE ==> [{}]:{}", this.getRedisStreamKey(), msg, e);
        } finally {
            if (!aBoolean) {
                HashMap<String, String> map = CollectionUtil.mapStringString();
                map.put("message", msg);
                stringRedisTemplate.opsForStream().add(StreamRecords.mapBacked(map).withStreamKey(this.getRedisStreamKey()));
            }
        }
        return aBoolean;
    }
}
