package com.liquidnet.service.adam.mapper;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.liquidnet.service.adam.dto.AdamMemberOrderDto;
import com.liquidnet.service.adam.dto.MemberOrderDto;
import com.liquidnet.service.adam.entity.AdamMemberOrder;
import org.apache.ibatis.annotations.Param;
import org.apache.ibatis.annotations.Select;

import java.util.List;
import java.util.Map;

public interface AdamMemberOrderMapper extends BaseMapper<AdamMemberOrder> {
    List<MemberOrderDto> getMemberOrderList(Map<String, Object> map);

    @Select({"select amo.mid," +
            "amo.order_no as orderNo," +
            "amo.uid," +
            "amo.mode," +
            "amo.price," +
            "amo.price_paid as pricePaid," +
            "amo.member_name as memberName," +
            "amo.member_id as memberId," +
            "amo.member_price_id as memberPriceId," +
            "amo.days," +
            "amo.state," +
            "amo.member_no as memberNo," +
            "amo.birthday," +
            "amo.device_from as deviceFrom," +
            "amo.pay_type as payType," +
            "amo.pay_no as payNo," +
            "amo.payment_at as paymentAt," +
            "amo.created_at as createdAt," +
            "amo.updated_at as updatedAt," +
            "amo.client_ip as clientIp," +
            "amo.source," +
            "amo.version," +
            "amoe.express_status as expressStatus," +
            "amoe.express_receiver as expressReceiver," +
            "amoe.express_phone as expressPhone," +
            "amoe.express_address as expressAddress " +
            "from adam_member_order amo " +
            "left join adam_member_order_ext amoe on amo.order_no = amoe.order_no " +
            "order by amo.mid " +
            "limit #{rows},#{offset}"
    })
    List<AdamMemberOrderDto> selectMultiForMemberOrderDto(@Param("rows") int rows, @Param("offset") int offset);
}
