package com.liquidnet.service.platform.controller.goblin.activity;

import com.github.pagehelper.PageInfo;
import com.github.xiaoymin.knife4j.annotations.ApiOperationSupport;
import com.liquidnet.service.base.ResponseDto;
import com.liquidnet.service.goblin.dto.vo.GoblinNftExActivityVo;
import com.liquidnet.service.goblin.dto.vo.GoblinNftSkuVo;
import com.liquidnet.service.goblin.dto.vo.PageInfoVo;
import com.liquidnet.service.goblin.param.GoblinNftExActivityParam;
import com.liquidnet.service.goblin.service.IGoblinNftExActivityService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletResponse;
import javax.validation.Valid;
import java.util.List;

/**
 * @Author: wll
 * @Date:Create：in 2022/4/19 2:55 下午
 */


@Api(tags = "nft兑换活动")
@Slf4j
@Validated
@RestController
@RequestMapping("activity")
public class GoblinNftExActivityController {

    @Autowired
    IGoblinNftExActivityService iGoblinNftExActivityService;

    @ApiOperationSupport(order = 1)
    @ApiOperation(value = "添加nft兑换活动")
    @PostMapping("add")
    public ResponseDto<Object> add(@Valid @RequestBody GoblinNftExActivityParam goblinNftExActivityParam) {
        return iGoblinNftExActivityService.add(goblinNftExActivityParam);
    }

    @ApiOperationSupport(order = 2)
    @ApiOperation(value = "活动列表")
    @PostMapping("pageList")
    public ResponseDto<PageInfoVo> pageList(@Valid @RequestBody GoblinNftExActivityParam goblinNftExActivityParam) {
        return ResponseDto.success(iGoblinNftExActivityService.pageList(goblinNftExActivityParam));
    }


    @ApiOperationSupport(order = 3)
    @ApiOperation(value = "根据nft兑换活动获取绑定商品")
    @PostMapping("selectNftSkuByActivityId/{activityId}")
    public ResponseDto<List<GoblinNftSkuVo>> selectNftSkuByActivityId(@PathVariable("activityId") String activityId) {
        return ResponseDto.success(iGoblinNftExActivityService.selectNftSkuByActivityId(activityId));
    }

    @ApiOperationSupport(order = 4)
    @ApiOperation(value = "excel导出")
    @PostMapping("excel")
    public void excel(HttpServletResponse httpServletResponse, @RequestBody GoblinNftExActivityParam goblinNftExActivityParam) {
        iGoblinNftExActivityService.excel(httpServletResponse, goblinNftExActivityParam);
    }

}
