/*
 * Decompiled with CFR 0.152.
 */
package com.dingtalk.api;

import com.dingtalk.api.DingTalkClient;
import com.dingtalk.api.DingTalkSignatureUtil;
import com.taobao.api.ApiException;
import com.taobao.api.ApiRuleException;
import com.taobao.api.DefaultTaobaoClient;
import com.taobao.api.FileItem;
import com.taobao.api.TaobaoRequest;
import com.taobao.api.TaobaoResponse;
import com.taobao.api.TaobaoUploadRequest;
import com.taobao.api.internal.parser.json.ObjectJsonParser;
import com.taobao.api.internal.util.HttpResponseData;
import com.taobao.api.internal.util.RequestParametersHolder;
import com.taobao.api.internal.util.TaobaoHashMap;
import com.taobao.api.internal.util.TaobaoLogger;
import com.taobao.api.internal.util.TaobaoUtils;
import com.taobao.api.internal.util.WebV2Utils;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultDingTalkClient
extends DefaultTaobaoClient
implements DingTalkClient {
    protected boolean useJsonString = false;

    public DefaultDingTalkClient(String serverUrl) {
        super(serverUrl, null, null);
    }

    @Override
    public <T extends TaobaoResponse> T execute(TaobaoRequest<T> request, String accessKey, String accessSecret) throws ApiException {
        return this.execute(request, accessKey, accessSecret, null, null);
    }

    @Override
    public <T extends TaobaoResponse> T execute(TaobaoRequest<T> request, String accessKey, String accessSecret, String suiteTicket) throws ApiException {
        return this.execute(request, accessKey, accessSecret, suiteTicket, null);
    }

    @Override
    public <T extends TaobaoResponse> T execute(TaobaoRequest<T> request, String session) throws ApiException {
        if (request.getTopApiCallType() == null || request.getTopApiCallType().equals("top")) {
            return super.execute(request, session);
        }
        return this.executeOApi(request, session);
    }

    @Override
    public <T extends TaobaoResponse> T execute(TaobaoRequest<T> request, String accessKey, String accessSecret, String suiteTicket, String corpId) throws ApiException {
        if (request.getTopApiCallType() == null || request.getTopApiCallType().equals("top")) {
            return super.execute(request, null);
        }
        return this.executeOApi(request, null, accessKey, accessSecret, suiteTicket, corpId);
    }

    private <T extends TaobaoResponse> T executeOApi(TaobaoRequest<T> request, String session) throws ApiException {
        return this.executeOApi(request, session, null, null, null, null);
    }

    private <T extends TaobaoResponse> T executeOApi(TaobaoRequest<T> request, String session, String accessKey, String accessSecret, String suiteTicket, String corpId) throws ApiException {
        long start = System.currentTimeMillis();
        ObjectJsonParser<T> parser = null;
        if (this.needEnableParser) {
            parser = new ObjectJsonParser<T>(request.getResponseClass(), true);
        }
        if (this.needCheckRequest) {
            try {
                request.check();
            }
            catch (ApiRuleException e) {
                TaobaoResponse localResponse = null;
                try {
                    localResponse = (TaobaoResponse)request.getResponseClass().newInstance();
                }
                catch (Exception xe) {
                    throw new ApiException(xe);
                }
                try {
                    Class<?> clazz = localResponse.getClass();
                    Method errcodeMethod = clazz.getDeclaredMethod("setErrcode", Long.class);
                    Method errmsgMethod = clazz.getDeclaredMethod("setErrmsg", String.class);
                    errcodeMethod.invoke((Object)localResponse, Long.parseLong(e.getErrCode()));
                    errmsgMethod.invoke((Object)localResponse, e.getErrMsg());
                    return (T)localResponse;
                }
                catch (Exception e2) {
                    throw new ApiException(e2);
                }
            }
        }
        RequestParametersHolder requestHolder = new RequestParametersHolder();
        TaobaoHashMap appParams = new TaobaoHashMap((Map<? extends String, ? extends String>)request.getTextParams());
        requestHolder.setApplicationParams(appParams);
        TaobaoHashMap protocalMustParams = new TaobaoHashMap();
        protocalMustParams.put("access_token", session);
        requestHolder.setProtocalMustParams(protocalMustParams);
        try {
            String fullUrl;
            if (accessKey != null) {
                Long timestamp = System.currentTimeMillis();
                String canonicalString = DingTalkSignatureUtil.getCanonicalStringForIsv(timestamp, suiteTicket);
                String signature = DingTalkSignatureUtil.computeSignature(accessSecret, canonicalString);
                HashMap<String, String> ps = new HashMap<String, String>();
                ps.put("accessKey", accessKey);
                ps.put("signature", signature);
                ps.put("timestamp", timestamp + "");
                if (suiteTicket != null) {
                    ps.put("suiteTicket", suiteTicket);
                }
                if (corpId != null) {
                    ps.put("corpId", corpId);
                }
                String queryStr = DingTalkSignatureUtil.paramToQueryString(ps, "utf-8");
                fullUrl = this.serverUrl.indexOf("?") > 0 ? this.serverUrl + "&" + queryStr : this.serverUrl + "?" + queryStr;
            } else {
                fullUrl = this.serverUrl.indexOf("?") > 0 ? this.serverUrl + (session != null && session.length() > 0 ? "&access_token=" + session : "") : this.serverUrl + (session != null && session.length() > 0 ? "?access_token=" + session : "");
            }
            HttpResponseData data = null;
            if (this.useGzipEncoding) {
                request.getHeaderMap().put("Accept-Encoding", "gzip");
            }
            if ("GET".equals(request.getTopHttpMethod())) {
                data = WebV2Utils.doGet(fullUrl, appParams, this.connectTimeout, this.readTimeout);
            } else if (request instanceof TaobaoUploadRequest) {
                TaobaoUploadRequest uRequest = (TaobaoUploadRequest)request;
                Map<String, FileItem> fileParams = TaobaoUtils.cleanupMap(uRequest.getFileParams());
                data = WebV2Utils.doPost(fullUrl, (Map<String, String>)appParams, fileParams, "UTF-8", this.connectTimeout, this.readTimeout, request.getHeaderMap());
            } else {
                HashMap<String, Object> jsonParams = new HashMap<String, Object>();
                for (Map.Entry paramEntry : appParams.entrySet()) {
                    Object childMap;
                    String key = (String)paramEntry.getKey();
                    String value = (String)paramEntry.getValue();
                    if (this.useJsonString) {
                        jsonParams.put(key, value);
                        continue;
                    }
                    if (value.startsWith("[") && value.endsWith("]")) {
                        childMap = (List)TaobaoUtils.jsonToObject(value);
                        jsonParams.put(key, childMap);
                        continue;
                    }
                    if (value.startsWith("{") && value.endsWith("}")) {
                        childMap = (Map)TaobaoUtils.jsonToObject(value);
                        jsonParams.put(key, childMap);
                        continue;
                    }
                    jsonParams.put(key, value);
                }
                data = WebV2Utils.doPostWithJson(fullUrl, jsonParams, "UTF-8", this.connectTimeout, this.readTimeout);
            }
            requestHolder.setResponseBody(data.getBody());
            requestHolder.setResponseHeaders(data.getHeaders());
        }
        catch (IOException e) {
            TaobaoLogger.logApiError("_dingtalk_", request.getApiMethodName(), this.serverUrl, requestHolder.getAllParams(), System.currentTimeMillis() - start, e.toString());
            throw new ApiException(e);
        }
        TaobaoResponse tRsp = null;
        if (this.needEnableParser) {
            tRsp = (TaobaoResponse)parser.parse(requestHolder.getResponseBody(), "dingtalk");
            tRsp.setBody(requestHolder.getResponseBody());
        } else {
            try {
                tRsp = (TaobaoResponse)request.getResponseClass().newInstance();
                tRsp.setBody(requestHolder.getResponseBody());
            }
            catch (Exception e) {
                throw new ApiException(e);
            }
        }
        tRsp.setParams(appParams);
        if (!tRsp.isSuccess()) {
            TaobaoLogger.logApiError("_dingtalk_", request.getApiMethodName(), this.serverUrl, requestHolder.getAllParams(), System.currentTimeMillis() - start, tRsp.getBody());
        }
        return (T)tRsp;
    }

    public boolean isUseJsonString() {
        return this.useJsonString;
    }

    public void setUseJsonString(boolean useJsonString) {
        this.useJsonString = useJsonString;
    }
}

