package com.liquidnet.client.admin.zhengzai.adam.dto;

import com.liquidnet.client.admin.common.annotation.Excel;
import com.liquidnet.commons.lang.util.DateUtil;
import com.liquidnet.service.adam.entity.AdamMemberCode;
import lombok.Data;

import java.io.Serializable;

@Data
public class AdamMemberCodeExcelDto implements Serializable, Cloneable {
    private static final long serialVersionUID = -6775626480969657499L;
    @Excel(name = "卡号")
    private String memberNo;
    @Excel(name = "会员码", width = 30)
    private String code;
    @Excel(name = "使用状态")
    private String state;
    @Excel(name = "使用时间", width = 30)
    private String useAt;

    private static final AdamMemberCodeExcelDto obj = new AdamMemberCodeExcelDto();

    public static AdamMemberCodeExcelDto getNew() {
        try {
            return (AdamMemberCodeExcelDto) obj.clone();
        } catch (CloneNotSupportedException e) {
            return new AdamMemberCodeExcelDto();
        }
    }

    public AdamMemberCodeExcelDto copy(AdamMemberCode source) {
        if (null == source) return this;
        this.setMemberNo(source.getMemberNo());
        this.setCode(source.getCode());
        this.setState(source.getState() == 0 ? "可用" : "已用");
        this.setUseAt(DateUtil.Formatter.yyyyMMddHHmmss.format(source.getUseAt()));
        return this;
    }
}
