package com.liquidnet.client.admin.zhengzai.kylin.service;


import com.liquidnet.service.kylin.entity.KylinOrderTicketEntities;
import com.liquidnet.service.kylin.entity.KylinOrderTickets;

import java.util.List;

public interface IToolService {
    /**
     * 修改订单入场人
     *
     * @param enterIdCard
     * @param enterMobile
     * @param enterName
     * @param enterType
     * @param orderTicketEntitiesId
     * @return
     */
    Boolean supplementEnter(String orderTicketEntitiesId, String enterName, String enterMobile, String enterIdCard, Integer enterType,String orderId);

    /**
     * 根据入场人id
     *
     * @param orderTicketEntitiesId
     * @return
     */
    KylinOrderTicketEntities getSingleEnter(String orderTicketEntitiesId);

    /**
     * 根据订单号查询 订单入场人信息
     *
     * @param orderCode
     * @return
     */
    List<KylinOrderTicketEntities> getOrderTicketEnterByOrderCode(String orderCode);
    /**
     * 根据订单号获取收货人信息
     *
     * @param orderCode
     * @return
     */
    List<KylinOrderTickets> getExpressContactsByOrderCode(String orderCode);

    Integer updOrderExpressPhoneByOrderCode(String orderCode, String expressPhone);
}
