package com.liquidnet.service.kylin.dto.vo;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;

@Data
public class KylinAgentVo implements Serializable, Cloneable {
    @ApiModelProperty(value = "代理类型（1：总代，2：普代）")
    private int identity;
    @ApiModelProperty(value = "0-正常|1-黑名单")
    private int isBlack;
    @ApiModelProperty(value = "票提")
    private BigDecimal carry;

    private static final KylinAgentVo obj = new KylinAgentVo();

    public static KylinAgentVo getNew() {
        try {
            return (KylinAgentVo) obj.clone();
        } catch (CloneNotSupportedException e) {
            return new KylinAgentVo();
        }
    }
}
