package com.liquidnet.client.admin.zhengzai.kylin.service.impl;

import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.github.pagehelper.PageInfo;
import com.liquidnet.client.admin.zhengzai.kylin.service.IKylinExpressModuleService;
import com.liquidnet.client.admin.zhengzai.kylin.utils.DataUtils;
import com.liquidnet.commons.lang.util.IDGenerator;
import com.liquidnet.service.kylin.dto.param.admin.ExpressModuleFromParam;
import com.liquidnet.service.kylin.dto.vo.KylinExpressModuleVo;
import com.liquidnet.service.kylin.entity.KylinExpressModule;
import com.liquidnet.service.kylin.mapper.KylinExpressModuleMapper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;

/**
 * <p>
 * 快递模板表 服务实现类
 * </p>
 *
 * @author jiangxiulong
 * @since 2021-11-15
 */
@Service
public class KylinExpressModuleServiceImpl extends ServiceImpl<KylinExpressModuleMapper, KylinExpressModule> implements IKylinExpressModuleService {
    @Autowired
    private KylinExpressModuleMapper moduleMapper;

    @Autowired
    private DataUtils dataUtils;

    @Override
    public Integer createForm(ExpressModuleFromParam param) {
        try {
            KylinExpressModule expressModule = ExpressModuleFromParam.getNew().copy(param);
            String moduleId = IDGenerator.nextSnowId();
            expressModule.setModuleId(moduleId);
            int insert = moduleMapper.insert(expressModule);
            // redis处理
            this.expressModuleList();
            return insert;
        } catch (Exception e) {
            log.error("创建失败 [e:{}]", e);
            return 0;
        }
    }

    @Override
    public Integer updateForm(ExpressModuleFromParam param) {
        try {
            KylinExpressModule expressModule = ExpressModuleFromParam.getNew().copy(param);
            expressModule.setUpdatedAt(LocalDateTime.now());
            String moduleId = param.getModuleId();
            int update = moduleMapper.update(
                    expressModule,
                    Wrappers.lambdaUpdate(KylinExpressModule.class).eq(KylinExpressModule::getModuleId, moduleId)
            );
            // redis处理
            this.expressModuleList();
            return update;
        } catch (Exception e) {
            log.error("编辑失败 [e:{}]", e);
            return 0;
        }
    }

    @Override
    public Integer isOnline(String moduleId, Integer isOnline) {
        KylinExpressModule expressModule = KylinExpressModule.getNew();
        expressModule.setIsOnline(isOnline);
        expressModule.setUpdatedAt(LocalDateTime.now());
        int update = moduleMapper.update(
                expressModule,
                Wrappers.lambdaUpdate(KylinExpressModule.class).eq(KylinExpressModule::getModuleId, moduleId)
        );
        // redis处理
        this.expressModuleList();
        return update;
    }

    @Override
    public KylinExpressModule detail(String getModuleId) {
        KylinExpressModule expressModule = moduleMapper.selectOne(
                Wrappers.lambdaQuery(KylinExpressModule.class).eq(KylinExpressModule::getModuleId, getModuleId)
        );
        return expressModule;
    }

    @Override
    public PageInfo<KylinExpressModule> expressList() {
        List<KylinExpressModule> kylinExpressModules = moduleMapper.selectList(Wrappers.lambdaQuery());
        return new PageInfo(kylinExpressModules);
    }

    private void expressModuleList() {
        // 列表
        List<KylinExpressModule> kylinExpressModules = moduleMapper.selectList(
                Wrappers.lambdaQuery(KylinExpressModule.class).eq(KylinExpressModule::getIsOnline, 2)
        );
        List<KylinExpressModuleVo> voList = new ArrayList<>();
        kylinExpressModules.forEach(r -> {
            KylinExpressModuleVo copy = KylinExpressModuleVo.getNew().copy(r);
            voList.add(copy);
        });

        dataUtils.setkylinExpressModules(voList);
    }
}
