package com.liquidnet.service.util;

import com.liquidnet.service.goblin.dto.vo.SmileSchoolVo;
import com.liquidnet.service.kylin.dto.vo.mongo.KylinPerformanceVo;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.stereotype.Component;

import java.util.List;

@Component
public class SmileMongoUtils {
    @Autowired
    MongoTemplate mongoTemplate;

    public KylinPerformanceVo getPerFormance(String id){
        return mongoTemplate.findOne(Query.query(Criteria.where("performancesId").is(id)),
                KylinPerformanceVo.class, KylinPerformanceVo.class.getSimpleName());
    }

    public List<SmileSchoolVo> getSchoole(String name){
        Query query = new Query();
        java.util.regex.Pattern pattern =
                java.util.regex.Pattern.compile("^.*" + name + ".*$", java.util.regex.Pattern.CASE_INSENSITIVE);
        query.addCriteria(Criteria.where("name").regex(pattern));
        return mongoTemplate.find(query, SmileSchoolVo.class, SmileSchoolVo.class.getSimpleName());
    }

}
