package com.liquidnet.client.admin.zhengzai.kylin.service.impl;

import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.fasterxml.jackson.core.type.TypeReference;
import com.github.pagehelper.PageInfo;
import com.liquidnet.client.admin.common.exception.BusinessException;
import com.liquidnet.client.admin.common.utils.StringUtils;
import com.liquidnet.client.admin.zhengzai.kylin.dto.OrderExportVo;
import com.liquidnet.client.admin.zhengzai.kylin.dto.OrderOutLineVo;
import com.liquidnet.client.admin.zhengzai.kylin.service.IExportService;
import com.liquidnet.client.admin.zhengzai.kylin.service.IImportService;
import com.liquidnet.client.admin.zhengzai.kylin.utils.DataUtils;
import com.liquidnet.client.admin.zhengzai.kylin.utils.OrderUtils;
import com.liquidnet.commons.lang.util.*;
import com.liquidnet.service.adam.dto.vo.AdamUserInfoVo;
import com.liquidnet.service.base.ResponseDto;
import com.liquidnet.service.kylin.constant.KylinTableStatusConst;
import com.liquidnet.service.kylin.dao.OrderExportDao;
import com.liquidnet.service.kylin.dto.vo.middle.KylinTicketTimesVo;
import com.liquidnet.service.kylin.dto.vo.middle.KylinTicketVo;
import com.liquidnet.service.kylin.dto.vo.mongo.KylinOrderTicketEntitiesVo;
import com.liquidnet.service.kylin.dto.vo.mongo.KylinOrderTicketVo;
import com.liquidnet.service.kylin.dto.vo.mongo.KylinPerformanceVo;
import com.liquidnet.service.kylin.entity.*;
import com.liquidnet.service.kylin.mapper.*;
import com.liquidnet.service.kylin.service.admin.IKylinPerformancesAdminService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.stereotype.Service;
import org.springframework.util.MultiValueMap;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.List;

@Service
@Slf4j
public class ExportServiceImpl implements IExportService {

    @Autowired
    KylinPerformancesMapper performancesMapper;

    @Override
    public List<OrderExportVo> exportOrderByPerformanceIdAll(String performancesId) {
        List<OrderExportDao> list = performancesMapper.exportOrderByPerformanceIdAll(performancesId);
        List<OrderExportVo> voList = new ArrayList();
        BeanUtils.copyProperties(list,voList);
        return voList;
    }

    @Override
    public List<OrderExportVo> exportOrderByPerformanceIdPay(String performancesId) {
        List<OrderExportDao> list = performancesMapper.exportOrderByPerformanceIdPay(performancesId);
        List<OrderExportVo> voList = new ArrayList();
        BeanUtils.copyProperties(list,voList);
        return voList;
    }
}
