package com.liquidnet.service.galaxy.dto.param;

import com.liquidnet.commons.lang.util.JsonUtils;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

/**
 * @author AnJiabin <anjiabin@zhengzai.tv>
 * @version V1.0
 * @Description: TODO
 * @class: GalaxyQueryNftInfoRespDto
 * @Package com.liquidnet.service.galaxy.dto.param
 * @Copyright: LightNet @ Copyright (c) 2022
 * @date 2022/4/8 16:27
 */
@ApiModel(value = "GalaxyQueryTransNftInfoRespDto", description = "NFT信息查询")
@Data
public class GalaxyQueryTransNftInfoRespDto{
    /**
     * nftId
     */
    @ApiModelProperty(position = 1, required = true, value = "nftId")
    private String nftId;
    /**
     * 所有者地址
     */
    @ApiModelProperty(position = 1, required = true, value = "所有者地址")
    private String ownerAddr;
    /**
     * 发行地址
     */
    @ApiModelProperty(position = 1, required = true, value = "发行地址")
    private String publishAddr;
    /**
     * 作品名字，中英文数字均可，不超过256个字符
     */
    @ApiModelProperty(position = 1, required = true, value = "作品名字")
    private String name;
    /**
     * 作品简介，500个字符以内
     */
    @ApiModelProperty(position = 1, required = true, value = "作品简介")
    private String desc;
    /**
     * 作品url，不超过2048个字符 疑问：应该是发行的1024吧？
     */
    @ApiModelProperty(position = 1, required = true, value = "作品url")
    private String url;
    /**
     * 预览图url
     */
    @ApiModelProperty(position = 1, required = true, value = "预览图url")
    private String displayUrl;
    /**
     * 交易时间
     */
    @ApiModelProperty(position = 1, required = true, value = "交易时间")
    private String tradeTime;
    /**
     * 交易hash
     */
    @ApiModelProperty(position = 1, required = true, value = "交易hash")
    private String tradeHash;
    /**
     * 转让状态(-1初始化 0转让中 1转让成功 2转让失败 )
     */
    @ApiModelProperty(position = 1, required = true, value = "-1初始化 0转让中 1转让成功 2转让失败")
    private String tradeStatus;

    @Override
    public String toString(){
        return JsonUtils.toJson(this);
    }

    private static final GalaxyQueryTransNftInfoRespDto obj = new GalaxyQueryTransNftInfoRespDto();

    public static GalaxyQueryTransNftInfoRespDto getNew() {
        try {
            return (GalaxyQueryTransNftInfoRespDto) obj.clone();
        } catch (CloneNotSupportedException e) {
            return new GalaxyQueryTransNftInfoRespDto();
        }
    }
}