package com.liquidnet.client.admin.zhengzai.goblin.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.liquidnet.client.admin.zhengzai.goblin.service.IGoblinCommonService;
import com.liquidnet.commons.lang.util.StringUtil;
import com.liquidnet.service.goblin.dto.GoblinGoodsSearchDto;
import com.liquidnet.service.goblin.dto.GoblinMixSearchDto;
import com.liquidnet.service.goblin.dto.GoblinSkusSearchDto;
import com.liquidnet.service.goblin.dto.GoblinStoreSearchDto;
import com.liquidnet.service.goblin.entity.GoblinGoods;
import com.liquidnet.service.goblin.entity.GoblinGoodsSku;
import com.liquidnet.service.goblin.entity.GoblinMix;
import com.liquidnet.service.goblin.entity.GoblinStoreInfo;
import com.liquidnet.service.goblin.mapper.GoblinGoodsMapper;
import com.liquidnet.service.goblin.mapper.GoblinGoodsSkuMapper;
import com.liquidnet.service.goblin.mapper.GoblinMixMapper;
import com.liquidnet.service.goblin.mapper.GoblinStoreInfoMapper;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.List;

/**
 * <p>
 * 店铺基础信息 服务实现类
 * </p>
 *
 * @author liquidnet
 * @since 2021-12-27
 */
@Slf4j
@Service
public class GoblinCommonServiceImpl implements IGoblinCommonService {

    @Autowired
    GoblinStoreInfoMapper goblinStoreInfoMapper;
    @Autowired
    GoblinGoodsMapper goblinGoodsMapper;
    @Autowired
    GoblinGoodsSkuMapper goblinGoodsSkuMapper;
    @Autowired
    GoblinMixMapper goblinMixMapper;

    @Override
    public List<GoblinStoreSearchDto> storeSearch(String name, List<String> status) {
        List<GoblinStoreInfo> list = goblinStoreInfoMapper.selectList(Wrappers.lambdaQuery(GoblinStoreInfo.class)
                .like(GoblinStoreInfo::getStoreName, name)
                .in(GoblinStoreInfo::getStatus, status)
                .select(GoblinStoreInfo::getStoreId, GoblinStoreInfo::getStoreName, GoblinStoreInfo::getStatus));
        List<GoblinStoreSearchDto> dtoList = new ArrayList<>();
        for (GoblinStoreInfo item : list) {
            GoblinStoreSearchDto dto = GoblinStoreSearchDto.getNew();
            dto.setStatus(item.getStatus());
            dto.setStoreId(item.getStoreId());
            dto.setStoreName(item.getStoreName());
            dtoList.add(dto);
        }
        return dtoList;
    }

    @Override
    public List<GoblinGoodsSearchDto> goodsSearch(String name, Integer type) {
        if (type == null) {//普通商品
            type = 1;
        }
        LambdaQueryWrapper<GoblinGoods> queryWrapper = Wrappers.lambdaQuery(GoblinGoods.class);
        queryWrapper.ne(GoblinGoods::getDelFlg, "1");
//        queryWrapper.eq(GoblinGoods::getShelvesStatus, "3");
//        queryWrapper.eq(GoblinGoods::getSpuAppear, "0");
        queryWrapper.eq(GoblinGoods::getSpuType, type);
        if (StringUtil.isNotBlank(name)) {
            queryWrapper.like(GoblinGoods::getName, name);
        }
        List<GoblinGoods> list = goblinGoodsMapper.selectList(queryWrapper.last("limit 20"));
        List<GoblinGoodsSearchDto> dtoList = new ArrayList<>();
        for (GoblinGoods item : list) {
            GoblinGoodsSearchDto dto = GoblinGoodsSearchDto.getNew();
            dto.setSpuId(item.getSpuId());
            dto.setSpuName(item.getName());
            dtoList.add(dto);
        }
        return dtoList;
    }

    @Override
    public List<GoblinSkusSearchDto> skuSearch(String name, Integer type) {
        if (type == null) {//普通商品
            type = 1;
        }
        LambdaQueryWrapper<GoblinGoodsSku> queryWrapper = Wrappers.lambdaQuery(GoblinGoodsSku.class);
        queryWrapper.ne(GoblinGoodsSku::getDelFlg, "1");
//        queryWrapper.eq(GoblinGoodsSku::getShelvesStatus, "3");
//        queryWrapper.eq(GoblinGoodsSku::getSpuAppear, "0");
        queryWrapper.eq(GoblinGoodsSku::getSkuType, type);
        if (StringUtil.isNotBlank(name)) {
            queryWrapper.like(GoblinGoodsSku::getName, name);
        }
        List<GoblinGoodsSku> list = goblinGoodsSkuMapper.selectList(queryWrapper.last("limit 20"));
        List<GoblinSkusSearchDto> dtoList = new ArrayList<>();
        for (GoblinGoodsSku item : list) {
            GoblinSkusSearchDto dto = GoblinSkusSearchDto.getNew();
            dto.setSpuId(item.getSkuId());
            dto.setSpuName(item.getName());
            dtoList.add(dto);
        }
        return dtoList;
    }

    @Override
    public List<GoblinMixSearchDto> mixSearch(String name) {
        LambdaQueryWrapper<GoblinMix> queryWrapper = Wrappers.lambdaQuery(GoblinMix.class);
        queryWrapper.ne(GoblinMix::getDelTag, "1");
        if (StringUtil.isNotBlank(name)) {
            queryWrapper.like(GoblinMix::getName, name);
        }
        List<GoblinMix> list = goblinMixMapper.selectList(queryWrapper.last("limit 20"));
        List<GoblinMixSearchDto> dtoList = new ArrayList<>();
        for (GoblinMix item : list) {
            GoblinMixSearchDto dto = GoblinMixSearchDto.getNew();
            dto.setMixId(item.getMixId());
            dto.setName(item.getName());
            dto.setSellName(item.getSellName());
            dtoList.add(dto);
        }
        return dtoList;
    }
}
