package com.liquidnet.service.kylin.service.impl;

import com.liquidnet.common.cache.redis.util.RedisUtil;
import com.liquidnet.commons.lang.util.CollectionUtil;
import com.liquidnet.commons.lang.util.DateUtil;
import com.liquidnet.service.kylin.constant.KylinRedisConst;
import com.liquidnet.service.kylin.dto.vo.KylinBannersVo;
import com.liquidnet.service.kylin.entity.KylinBanners;
import com.liquidnet.service.kylin.service.admin.IKylinBannersService;
import com.liquidnet.service.kylin.utils.ObjectUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.stereotype.Service;

import java.util.Iterator;
import java.util.List;

/**
 * <p>
 * 轮播图 服务实现类
 * </p>
 *
 * @author jiangxiulong
 * @since 2021-05-02
 */
@Service
public class BannersServiceImpl implements IKylinBannersService {

    @Value("${liquidnet.aliyun.oss.imgUrl}")
    private String imgUrl;

    @Autowired
    MongoTemplate mongoTemplate;

    @Autowired
    RedisUtil redisUtil;

    public List<KylinBanners> blist(String position, String provinceName) {
        String nowTime = DateUtil.getNowTime();
        Object ListObj = redisUtil.get(KylinRedisConst.ADMIN_BANNER_LIST);
        List<KylinBanners> list = ObjectUtil.getKylinBannerListArrayList();
        if (null != ListObj) {
            list = (List<KylinBanners>) ListObj;
            if (!CollectionUtil.isEmpty(list)) {
                Iterator<KylinBanners> itBannerList = list.iterator();
                while (itBannerList.hasNext()) {
                    KylinBanners bannerInfo = itBannerList.next();
                    // 时间
                    String StartTime = bannerInfo.getOnlineStartTime();
                    String endTime = bannerInfo.getOnlineEndTime();

                    if (null != StartTime && null != endTime && !StartTime.isEmpty() && !endTime.isEmpty()) {
                        if (DateUtil.compareStrDay(nowTime, StartTime) < 0) { // 当前时间小雨开始时间 还未开始呢
                            itBannerList.remove();
                            continue;
                        }
                        if (DateUtil.compareStrDay(endTime, nowTime) < 0) { // 解释时间大于当前时间 已过期
                            itBannerList.remove();
                            continue;
                        }
                    }

                    // list
                    List<String> pList = bannerInfo.getPositionList();
                    Boolean pis = false;
                    if (null != pList) {
                        for (String positionName : pList) {
                            if (positionName.equals(position)) {
                                pis = true;
                            }
                        }
                    }
                    if (!pis || null == pList) {
                        itBannerList.remove();
                        continue;
                    }

                    if (bannerInfo.getPromotionType() != 1) {
                        List<String> proList = bannerInfo.getProvincesList();
                        Boolean prois = false;
                        if (null != proList) {
                            for (String proName : proList) {
                                if (proName.equals(provinceName)) {
                                    prois = true;
                                }
                            }
                        }
                        if (!prois || null == proList) {
                            itBannerList.remove();
                            continue;
                        }
                    }

                    String setCoverImg = imgUrl + bannerInfo.getCoverImg();
                    bannerInfo.setCoverImg(setCoverImg);
                }
            }
        }

        return list;
    }

}
