package com.liquidnet.service.sweet.controller;


import com.github.pagehelper.PageInfo;
import com.liquidnet.service.base.ResponseDto;
import com.liquidnet.service.sweet.dto.SweetManualArtistListDto;
import com.liquidnet.service.sweet.dto.SweetManualDto;
import com.liquidnet.service.sweet.entity.SweetManualArtists;
import com.liquidnet.service.sweet.service.ISweetManualArtistsService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

/**
 * <p>
 * 电子宣传手册艺人表 前端控制器
 * </p>
 *
 * @author liquidnet
 * @since 2021-07-23
 */
@Api(tags = "电子手册艺人")
@RestController
@RequestMapping("/sweet-manual-artists")
public class SweetManualArtistsController {

    @Autowired
    private ISweetManualArtistsService sweetManualArtistsService;

    @GetMapping("getList")
    @ApiOperation("宣传手册艺人列表")
    @ApiImplicitParams({
            @ApiImplicitParam(type = "query", dataType = "Integer", name = "page", value = "页数", required = true),
            @ApiImplicitParam(type = "query", dataType = "Integer", name = "size", value = "数量", required = true),
            @ApiImplicitParam(type = "query", dataType = "String", name = "manaulId", value = "手册id", required = true),
    })
    public ResponseDto<PageInfo<SweetManualArtistListDto>> getList(@RequestParam(defaultValue = "1") Integer page,
                                                                   @RequestParam(defaultValue = "10") Integer size,
                                                                   @RequestParam(defaultValue = "") String manualId) {
        return sweetManualArtistsService.getList(page, size, manualId);
    }

    @GetMapping("details")
    @ApiOperation("宣传手册艺人详情")
    @ApiImplicitParams({
            @ApiImplicitParam(type = "query", dataType = "String", name = "manualRelationId", value = "手册艺人id", required = true),
    })
    public ResponseDto<SweetManualArtistListDto> details(@RequestParam(defaultValue = "") String manualRelationId) {
        return sweetManualArtistsService.details(manualRelationId);
    }

    @PostMapping("add")
    @ApiOperation("宣传手册艺人添加")
    @ApiImplicitParams({
            @ApiImplicitParam(type = "query", dataType = "String", name = "manualId", value = "手册id", required = true),
            @ApiImplicitParam(type = "query", dataType = "String", name = "artistId", value = "艺人id", required = true),
            @ApiImplicitParam(type = "query", dataType = "String", name = "stageId", value = "场地id", required = true),
            @ApiImplicitParam(type = "query", dataType = "String", name = "performanceStart", value = "演出开始时间", required = false),
            @ApiImplicitParam(type = "query", dataType = "String", name = "performanceEnd", value = "演出结束时间", required = false),
            @ApiImplicitParam(type = "query", dataType = "String", name = "signatureStart", value = "签售开始时间", required = false),
            @ApiImplicitParam(type = "query", dataType = "String", name = "signatureEnd", value = "签售结束时间", required = false),
    })
    public ResponseDto<Boolean> add(@RequestParam(defaultValue = "1") String manualId,
                                    @RequestParam(defaultValue = "10") String artistId,
                                    @RequestParam(defaultValue = "") String stageId,
                                    @RequestParam(defaultValue = "", required = false) String performanceStart,
                                    @RequestParam(defaultValue = "", required = false) String performanceEnd,
                                    @RequestParam(defaultValue = "", required = false) String signatureStart,
                                    @RequestParam(defaultValue = "", required = false) String signatureEnd) {
        return sweetManualArtistsService.add(manualId, artistId, stageId, performanceStart, performanceEnd, signatureStart, signatureEnd);
    }

    @PostMapping("change")
    @ApiOperation("宣传手册艺人修改")
    @ApiImplicitParams({
            @ApiImplicitParam(type = "query", dataType = "String", name = "manualRelationId", value = "手册艺人id", required = true),
            @ApiImplicitParam(type = "query", dataType = "String", name = "artistId", value = "艺人id", required = true),
            @ApiImplicitParam(type = "query", dataType = "String", name = "stageId", value = "场地id", required = true),
            @ApiImplicitParam(type = "query", dataType = "String", name = "performanceStart", value = "演出开始时间", required = false),
            @ApiImplicitParam(type = "query", dataType = "String", name = "performanceEnd", value = "演出结束时间", required = false),
            @ApiImplicitParam(type = "query", dataType = "String", name = "signatureStart", value = "签售开始时间", required = false),
            @ApiImplicitParam(type = "query", dataType = "String", name = "signatureEnd", value = "签售结束时间", required = false),
    })
    public ResponseDto<Boolean> change(@RequestParam(defaultValue = "1") String manualRelationId,
                                       @RequestParam(defaultValue = "10") String artistId,
                                       @RequestParam(defaultValue = "") String stageId,
                                       @RequestParam(defaultValue = "", required = false) String performanceStart,
                                       @RequestParam(defaultValue = "", required = false) String performanceEnd,
                                       @RequestParam(defaultValue = "", required = false) String signatureStart,
                                       @RequestParam(defaultValue = "", required = false) String signatureEnd) {
        return sweetManualArtistsService.change(manualRelationId, artistId, stageId, performanceStart, performanceEnd, signatureStart, signatureEnd);
    }

    @DeleteMapping("delete")
    @ApiOperation("宣传手册艺人删除")
    @ApiImplicitParams({
            @ApiImplicitParam(type = "query", dataType = "String", name = "manualRelationId", value = "手册艺人id", required = true)
    })
    public ResponseDto<Boolean> delete(@RequestParam(defaultValue = "1") String manualRelationId) {
        return sweetManualArtistsService.delete(manualRelationId);
    }
}
