package com.liquidnet.service.galaxy.controller;

import com.github.xiaoymin.knife4j.annotations.ApiOperationSupport;
import com.liquidnet.commons.lang.util.StringUtil;
import com.liquidnet.service.base.ResponseDto;
import com.liquidnet.service.galaxy.aop.annotation.ControllerLog;
import com.liquidnet.service.galaxy.dto.param.*;
import com.liquidnet.service.galaxy.service.IGalaxyTradeService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import javax.annotation.Resource;
import javax.validation.Valid;
import java.util.ArrayList;
import java.util.List;

/**
 * @author AnJiabin <anjiabin@zhengzai.tv>
 * @version V1.0
 * @Description: NFT购买
 * @class: GalaxyNftTradeController
 * @Package com.liquidnet.service.galaxy.controller
 * @Copyright: LightNet @ Copyright (c) 2021
 * @date 2022/3/14 18:08
 */
@Api(tags = "NFT交易相关")
@RestController
@RequestMapping("nftTrade")
@Validated
@Slf4j
public class GalaxyTradeController {
    @Resource(name = "galaxyTradeServiceImpl")
    private IGalaxyTradeService galaxyTradeService;

    @ControllerLog(description = "NFT购买")
    @ApiOperationSupport(order = 1)
    @ApiOperation(value = "NFT购买")
    @PostMapping(value = {"nftBuy"})
    public ResponseDto<GalaxyNftBuyRespDto> nftBuy(@Valid @RequestBody GalaxyNftBuyReqDto reqDto){
        return galaxyTradeService.nftBuy(reqDto);
    }

    @ControllerLog(description = "NFT购买结果查询")
    @ApiOperationSupport(order = 1)
    @ApiOperation(value = "NFT购买结果查询")
    @PostMapping(value = {"nftBuyResultQuery"})
    public ResponseDto<GalaxyNftBuyResultQueryRespDto> nftBuyResultQuery(@Valid @RequestBody GalaxyNftBuyResultQueryReqDto reqDto){
        return galaxyTradeService.nftBuyResultQuery(reqDto);
    }

    @ControllerLog(description = "NFT购买(发行+购买)")
    @ApiOperationSupport(order = 1)
    @ApiOperation(value = "NFT购买(发行+购买)")
    @PostMapping(value = {"nftPublishAndBuy"})
    public ResponseDto<GalaxyNftPublishAndBuyRespDto> nftPublishAndBuy(@Valid @RequestBody GalaxyNftPublishAndBuyReqDto reqDto){
        return galaxyTradeService.nftPublishAndBuy(reqDto);
    }

    @ControllerLog(description = "NFT发行购买结果查询")
    @ApiOperationSupport(order = 1)
    @ApiOperation(value = "NFT发行购买结果查询")
    @PostMapping(value = {"nftPublishAndBuyResultQuery"})
    public ResponseDto<GalaxyNftPublishAndBuyResultQueryRespDto> nftPublishAndBuyResultQuery(@Valid @RequestBody GalaxyNftPublishAndBuyResultQueryReqDto reqDto){
        return galaxyTradeService.nftPublishAndBuyResultQuery(reqDto);
    }

    @ControllerLog(description = "NFT发行购买结果批量查询")
    @ApiOperationSupport(order = 1)
    @ApiOperation(value = "NFT发行购买结果批量查询")
    @PostMapping(value = {"nftPublishAndBuyResultBatchQuery"})
    public ResponseDto<GalaxyNftPublishAndBuyResultBatchQueryRespDto> nftPublishAndBuyResultBatchQuery(@Valid @RequestBody GalaxyNftPublishAndBuyResultBatchQueryReqDto reqDto){
        //定义返回结果
        List<GalaxyNftPublishAndBuyRouterBatchQueryRespDto> batchQueryRespDtosList = new ArrayList<>();
        //获取请求信息
        List<GalaxyNftPublishAndBuyResultBatchQueryReqDto.RouterOrderInfo> routerOrderInfoList = reqDto.getRouterOrderInfoList();
        routerOrderInfoList.forEach(routerOrderInfo -> {
            GalaxyNftPublishAndBuyRouterBatchQueryReqDto batchQueryReqDto =  GalaxyNftPublishAndBuyRouterBatchQueryReqDto.getNew();
            batchQueryReqDto.setUserId(routerOrderInfo.getUserId());
            batchQueryReqDto.setRouterType(routerOrderInfo.getRouterType());
            batchQueryReqDto.setNftOrderPayIdList(routerOrderInfo.getNftOrderPayIdList());
            ResponseDto<GalaxyNftPublishAndBuyRouterBatchQueryRespDto> responseDtoTemp = galaxyTradeService.nftPublishAndBuyResultBatchQuery(batchQueryReqDto);
            if(StringUtil.isNotNull(responseDtoTemp)&&responseDtoTemp.isSuccess()){
                batchQueryRespDtosList.add(responseDtoTemp.getData());
            }
        });
        GalaxyNftPublishAndBuyResultBatchQueryRespDto respDto = GalaxyNftPublishAndBuyResultBatchQueryRespDto.getNew();
        respDto.setUserId(reqDto.getUserId());
        respDto.setRouterBuyInfoList(batchQueryRespDtosList);
        return ResponseDto.success(respDto);
    }

//    @ControllerLog(description = "NFT购买支付结果查询")
//    @ApiOperationSupport(order = 1)
//    @ApiOperation(value = "NFT购买支付结果查询")
//    @PostMapping(value = {"nftBuyPayResultQuery"})
//    public ResponseDto<GalaxyNftBuyPayResultQueryRespDto> nftBuyPayResultQuery(@Valid @RequestBody GalaxyNftBuyPayResultQueryReqDto reqDto){
//        return galaxyTradeService.nftBuyPayResultQuery(reqDto);
//    }
}
