package com.liquidnet.service.adam.dto;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.NonNull;

import javax.validation.constraints.*;
import java.io.Serializable;
import java.math.BigDecimal;

/**
 * 会员价格
 */
@ApiModel(value = "AdamMemberPriceParam", description = "添加/编辑会员价格")
@Data
public class AdamMemberPriceParam implements Serializable {
    private static final long serialVersionUID = -6432796310264973696L;
    @ApiModelProperty(position = 1, value = "会员价格ID")
    private String memberPriceId;
    @ApiModelProperty(position = 2, value = "会员类型ID")
    @NotBlank
    private String memberId;
    @ApiModelProperty(position = 3, value = "状态:0-不可用,1-上线中,2-已下线", allowableValues = "0,1,2")
    @NotNull
    @Min(1)
    @Max(2)
    private Integer state;
    @ApiModelProperty(position = 4, value = "会员价格包名称", example = "年卡")
    @Size(min = 1, max = 30)
    private String name;
    @ApiModelProperty(position = 5, value = "原价", example = "199")
    @DecimalMin("0.01")
    private BigDecimal price;
    @ApiModelProperty(position = 6, value = "折扣价", example = "199")
    @DecimalMin("0.01")
    private BigDecimal priceFixed;
    @ApiModelProperty(position = 7, value = "会员包有效天数", example = "365")
    @NotNull
    @Min(30)
    private Integer days;
    @ApiModelProperty(position = 8, value = "会员包须知", example = "会员包须知")
    private String detail;
}
