package com.liquidnet.service.util;

import com.liquidnet.commons.lang.util.CollectionUtil;
import com.liquidnet.service.base.constant.MQConst;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.connection.stream.StreamRecords;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.stereotype.Component;

import java.util.HashMap;

@Component
public class QueueUtils {

    //    @Autowired
//    private RabbitTemplate rabbitTemplate;
    @Autowired
    StringRedisTemplate stringRedisTemplate;

    /**
     * 发送消息 - RABBIT
     *
     * @param exchange 交换机
     * @param routeKey 路径
     * @param jsonMsg  Json字符串
     */
//    public void sendMsgByRabbit(String exchange, String routeKey, String jsonMsg) {
//        rabbitTemplate.convertAndSend(exchange, routeKey, jsonMsg);
//    }

    /**
     * 发送消息 - REDIS
     *
     * @param streamKey Redis消费Key
     * @param jsonMsg   Json字符串
     */
    public void sendMsgByRedis(String streamKey, String jsonMsg) {
        HashMap<String, String> map = CollectionUtil.mapStringString();
        map.put("message", jsonMsg);
        stringRedisTemplate.opsForStream().add(StreamRecords.mapBacked(map).withStreamKey(streamKey));
    }

    /**
     * 发送消息 - REDIS [XLS]
     *
     * @param xlsPath xls 对应的OSS 全量路径
     * @param type    [1-添加|2-删除]
     * @param skuId   skuId
     */
    public void sendMsgByRedisXls(String xlsPath, String type, String skuId) {
        if (xlsPath == null || xlsPath.equals("") || type == null || type.equals("") || skuId == null || skuId.equals("")) {

        } else {
            HashMap<String, String> map = CollectionUtil.mapStringString();
            map.put("message", xlsPath);
            map.put("type", type);
            map.put("skuId", skuId);
            stringRedisTemplate.opsForStream().add(StreamRecords.mapBacked(map).withStreamKey(MQConst.GoblinQueue.GOBLIN_XLS_OPERA.getKey()));
        }
    }
}
