package com.liquidnet.service.order.service.impl;


import com.liquidnet.commons.lang.util.CollectionUtil;
import com.liquidnet.commons.lang.util.CurrentUtil;
import com.liquidnet.commons.lang.util.IDGenerator;
import com.liquidnet.service.base.ResponseDto;
import com.liquidnet.service.goblin.constant.GoblinStatusConst;
import com.liquidnet.service.goblin.constant.NftAccStatusEnum;
import com.liquidnet.service.goblin.dto.GoblinUserNftAccInfoVo;
import com.liquidnet.service.goblin.dto.manage.MixOrderParam;
import com.liquidnet.service.goblin.dto.vo.*;
import com.liquidnet.service.goblin.entity.GoblinNftOrder;
import com.liquidnet.service.goblin.entity.GoblinStoreOrder;
import com.liquidnet.service.goblin.param.SyncOrderParam;
import com.liquidnet.service.goblin.service.IMixOrderService;
import com.liquidnet.service.order.utils.*;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang.StringUtils;
import org.apache.tomcat.jni.Local;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.HashMap;
import java.util.List;

import static com.liquidnet.commons.lang.util.DateUtil.DTF_YMD_HMS;


@Service
@Slf4j
public class MixOrderServiceImpl implements IMixOrderService {

    @Autowired
    GoblinRedisUtils redisUtils;
    @Autowired
    GoblinMongoUtils mongoUtils;
    @Autowired
    GoblinOrderUtils orderUtils;
    @Autowired
    GoblinNftOrderUtils nftOrderUtils;
    @Autowired
    QueueUtils queueUtils;

    @Value("${liquidnet.service.order.url}")
    private String orderUrl;

    @Override
    public ResponseDto<GoblinPayInnerResultVo> checkOrder(MixOrderParam param, String uid) {
        GoblinMixDetailsVo mixVo = redisUtils.getMixDetails(param.getMixId());
        String mixId = mixVo.getMixId();
        String mobile = StringUtils.defaultString(((String) CurrentUtil.getTokenClaims().get(CurrentUtil.TOKEN_MOBILE)), "");
        String nickName = StringUtils.defaultString(((String) CurrentUtil.getTokenClaims().get(CurrentUtil.TOKEN_NICKNAME)), "");
        String headerCliSource = CurrentUtil.getHeaderCliSource(), headerCliVersion = CurrentUtil.getHeaderCliVersion();
        String source = headerCliSource == null ? "" : headerCliSource, version = headerCliVersion == null ? "" : headerCliVersion;
        String orderMasterCode = IDGenerator.storeMasterCode();//总订单号

        List<String> canBuyIds = CollectionUtil.linkedListString();//有库存的id
        HashMap<String, Object> boxSkuId = CollectionUtil.mapStringObject();//盲盒种的skuid
        HashMap<String, Object> stockSkuId = CollectionUtil.mapStringObject();  // 盲盒id
        //判断 活动状态
        LocalDateTime st = LocalDateTime.parse(mixVo.getTimeStart(), DTF_YMD_HMS);
        LocalDateTime et = LocalDateTime.parse(mixVo.getTimeEnd(), DTF_YMD_HMS);
        LocalDateTime nt = LocalDateTime.now();
        if (!nt.isAfter(st) && nt.isBefore(et)) {
            return ResponseDto.failure("不在活动有效期内");
        }
        //判断白名单
        int whiteType = mixVo.getWhiteType();
        Boolean canBuy = redisUtils.getListCanBuy(mixId, mixId, mobile, uid, whiteType == 2 ? -1 : whiteType);
        if (!canBuy) {
            return ResponseDto.failure("该藏品仅对部分用户开放～");
        }
        //判断限购
        Integer limitCount = mixVo.getLimit();
        int buyCount = redisUtils.incrMixLimit(mixId, uid);
        if (buyCount > limitCount) {
            return ResponseDto.failure("超出限购数量");
        }
        //构建 各个商品信息
        List<GoblinGoodsSkuInfoVo> skuInfoList = ObjectUtil.cloneArrayGoblinGoodsSkuInfoListVo();
        List<GoblinGoodsSkuInfoVo> nftInfoList = ObjectUtil.cloneArrayGoblinGoodsSkuInfoListVo();
        for (GoblinMixDetailsItemVo itemVo : mixVo.getItem()) {
            String skuId = itemVo.getSkuId();
            GoblinGoodsSkuInfoVo skuInfoVo = redisUtils.getGoodsSkuInfoVo(skuId);
            //库存处理
            if (skuInfoVo.getUnbox().equals("1")) {//盲盒
                GoblinGoodsInfoVo spuInfoVo = redisUtils.getGoodsInfoVo(skuInfoVo.getSpuId());
                List<String> skuIdList = spuInfoVo.getSkuIdList();
                if (CollectionUtil.isEmpty(skuIdList)) {
                    return ResponseDto.failure("该商品SPU不存在～");
                } else {
                    GoblinGoodsSkuInfoVo boxSkuInfo = nftOrderUtils.lotteryDraw(skuIdList, itemVo.getCount(), nt, null);
                    if (null == boxSkuInfo) {
                        return ResponseDto.failure("盲盒库存不足啦～");
                    } else {
                        canBuyIds.add(boxSkuInfo.getSkuId() + "," + itemVo.getCount());
                    }
                    boxSkuId.put(skuId, skuInfoVo.getSkuId());
                    stockSkuId.put(skuId, skuInfoVo.getSkuId());
                }
            } else {//正常
                if (skuInfoVo.getSkuType() == 1) {
                    stockSkuId.put(skuId, skuId);
                }
                int stock = redisUtils.decrSkuStock(mixId, skuId, itemVo.getCount());
                if (stock < 0) {
                    redisUtils.incrSkuStock(mixId, skuId, itemVo.getCount());
                    for (String canBuyId : canBuyIds) {
                        String[] data = canBuyId.split(",");
                        String skuIdSingle = data[0];
                        int count = Integer.parseInt(data[1]);
                        redisUtils.incrSkuStock(mixId, skuIdSingle, count);
                    }
                    return ResponseDto.failure("库存不足");
                } else {
                    canBuyIds.add(skuId + "," + itemVo.getCount());
                }
            }
            if (skuInfoVo.getSkuType() == 0) {
                skuInfoList.add(skuInfoVo);
            } else if (skuInfoVo.getSkuType() == 1) {
                nftInfoList.add(skuInfoVo);
            } else {
                return ResponseDto.failure("参数异常");
            }
        }
        // 认证验证
        if (nftInfoList.size() > 0) {
            GoblinUserNftAccInfoVo openAccountInfo = redisUtils.getOpenAccountInfo(uid);
            if (null == openAccountInfo || !NftAccStatusEnum.StatusAcc.SUCCESS.getCode().equals(openAccountInfo.getCode())) {
                return ResponseDto.failure("您还未开通数字账户");
            }
        }
        //下单
        //生成nft订单
        List<GoblinNftOrder> nftOrderList =  nftOrder(nftInfoList,boxSkuId,mobile,source,version,nickName,nt,uid,param.getPayType(),param.getDeviceFrom());
        //生成goblin订单

//        return payOrder();
    }

    //商品订单
    private  List<GoblinStoreOrder> goblinOrder() {
    }

    //nft订单
    private List<GoblinNftOrder> nftOrder(List<GoblinGoodsSkuInfoVo> nftSkuVo, HashMap<String, Object> boxSkuId, String mobile, String source, String version, String nickName, LocalDateTime now, String uid, String payType, String deviceFrom) {
        List<GoblinNftOrder> goblinNftOrderList = ObjectUtil.goblinNftOrderList();
        for (GoblinGoodsSkuInfoVo skuVo : nftSkuVo) {
            BigDecimal voucherPrice = BigDecimal.ZERO;
            BigDecimal storeVoucherPrice = BigDecimal.ZERO;
            String orderId = IDGenerator.nextSnowId();
            String orderCode = IDGenerator.storeCode(orderId);
            BigDecimal totalPrice = skuVo.getPrice();
            if (payType.equals("applepay")) {
                totalPrice = skuVo.getPriceV();
            }
            GoblinStoreInfoVo storeInfoVo = redisUtils.getStoreInfoVo(skuVo.getStoreId());
            String storeName = storeInfoVo.getStoreName();

            // 生成订单
            GoblinNftOrder nftOrder = GoblinNftOrder.getNew();
            nftOrder.setOrderId(orderId);
            nftOrder.setSpuId(skuVo.getSpuId());
            nftOrder.setSkuId(skuVo.getSkuId());
            nftOrder.setSkuTitle(skuVo.getName());
            nftOrder.setBoxSkuId((String) boxSkuId.get(skuVo.getSkuId()));
            nftOrder.setNum(1);
            nftOrder.setStoreId(skuVo.getStoreId());
            nftOrder.setStoreName(storeName);
            nftOrder.setOrderCode(orderCode);
            nftOrder.setUserId(uid);
            nftOrder.setUserName(nickName);
            nftOrder.setUserMobile(mobile);
            nftOrder.setListId("");
            nftOrder.setExCode("");
            nftOrder.setPriceTotal(totalPrice);
            nftOrder.setPriceCoupon(voucherPrice);
            nftOrder.setStorePriceCoupon(storeVoucherPrice);
            nftOrder.setPriceRedEnvelope(BigDecimal.ZERO);
            nftOrder.setPriceVoucher(voucherPrice.add(storeVoucherPrice));
            BigDecimal priceActual = totalPrice.subtract(voucherPrice).subtract(storeVoucherPrice);
            nftOrder.setPriceActual(priceActual.compareTo(BigDecimal.ZERO) < 0 ? BigDecimal.ZERO : priceActual);
            nftOrder.setUcouponId("");
            nftOrder.setStoreCouponId("");
            nftOrder.setRedEnvelopeCode("");
            nftOrder.setStatus(GoblinStatusConst.NftStatus.ORDER_STATUS_1.getValue());
            nftOrder.setSource(source);
            nftOrder.setOrderType(1);
            nftOrder.setPayType(payType);
            nftOrder.setDeviceFrom(deviceFrom);
            nftOrder.setVersion(version);
            nftOrder.setPayCountdownMinute(5);
            nftOrder.setIpAddress(CurrentUtil.getCliIpAddr());
            nftOrder.setCreatedAt(now);

            goblinNftOrderList.add(nftOrder);
        }
        return goblinNftOrderList;
    }


//    private GoblinPayInnerResultVo payOrder(List<GoblinNftOrder> nftOrder, List<GoblinStoreOrder> goblinOrder, String produceId) {
//        GoblinPayInnerResultVo NftPayResultVo = GoblinPayInnerResultVo.getNew();
//        return NftPayResultVo;
//    }

    @Override
    public String syncOrder(SyncOrderParam syncOrderParam) {
        return null;
    }

    @Override
    public ResponseDto<Integer> checkOrderResult(String orderId) {
        return null;
    }

    @Override
    public ResponseDto<Integer> checkOrderResultMaterCode(String materCode) {
        return null;
    }
}
