package com.liquidnet.client.admin.web.controller.zhengzai.kylin;

import com.fasterxml.jackson.core.type.TypeReference;
import com.github.pagehelper.PageInfo;
import com.liquidnet.client.admin.common.annotation.Log;
import com.liquidnet.client.admin.common.core.controller.BaseController;
import com.liquidnet.client.admin.common.core.domain.AjaxResult;
import com.liquidnet.client.admin.common.core.page.TableDataInfo;
import com.liquidnet.client.admin.common.enums.BusinessType;
import com.liquidnet.client.admin.zhengzai.kylin.dto.PerformanceOrderStatisCountResp;
import com.liquidnet.commons.lang.util.JsonUtils;
import com.liquidnet.service.kylin.dao.PerformanceAdminListDao;
import com.liquidnet.service.kylin.dao.PerformanceMemberAuditDao;
import com.liquidnet.service.kylin.dao.PerformanceOrderStatisticalDao;
import com.liquidnet.service.kylin.dto.param.PerformanceAdminListParam;
import com.liquidnet.service.kylin.dto.param.PerformanceMemberAuditParam;
import com.liquidnet.service.kylin.dto.param.SysDamaiParam;
import com.liquidnet.service.kylin.dto.vo.admin.KylinPerformanceAgentVo;
import com.liquidnet.service.kylin.dto.vo.admin.KylinPerformanceDamaiVo;
import com.liquidnet.service.kylin.dto.vo.admin.PerformanceRefundConfigVo;
import com.liquidnet.service.kylin.dto.vo.partner.KylinPerformanceMisVo;
import com.liquidnet.service.kylin.service.admin.IKylinPerformancesAdminService;
import com.liquidnet.service.kylin.service.other.DamaiService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.*;

import java.math.BigDecimal;
import java.util.List;


/**
 * 演出Controller
 *
 * @author anjiabin
 * @date 2021-05-24
 */
@Controller
@RequestMapping("/kylin/performances")
public class KylinPerformancesController extends BaseController {
    private String prefix = "zhengzai/kylin/performances";

    @Autowired
    private IKylinPerformancesAdminService kylinPerformancesService;

    @Autowired
    private DamaiService damaiService;

    //@RequiresPermissions("kylin:performances:view")
    @GetMapping()
    public String performances() {
        return prefix + "/performances";
    }

    /**
     * 查询演出列表
     */
    //@RequiresPermissions("kylin:performances:view")
    @Log(title = "演出列表", businessType = BusinessType.LIST)
    @PostMapping("/list")
    @ResponseBody
    public TableDataInfo list(PerformanceAdminListParam performanceAdminListParam) {
        PageInfo<PerformanceAdminListDao> result = kylinPerformancesService.getList(performanceAdminListParam);
        TableDataInfo rspData = new TableDataInfo();
        rspData.setCode(0);
        rspData.setRows(result.getList());
        rspData.setTotal(result.getTotal());
        return rspData;
    }

    //@RequiresPermissions("kylin:performances:view")
    @Log(title = "演出列表", businessType = BusinessType.DETAIL)
    @GetMapping(value = "/details/{performancesId}")
    public String performanceDetails(@PathVariable("performancesId") String performancesId, ModelMap mmap) {
        KylinPerformanceMisVo result = null;
        result = kylinPerformancesService.performanceDetails(performancesId);
        mmap.put("kylinPerformanceMisVo", result);
        return prefix + "/details";
    }

    @Log(title = "演出列表", businessType = BusinessType.AUDIT)
    @PostMapping(value = "/audit")
    //@RequiresPermissions("kylin:performances:view")
    @ResponseBody
    public AjaxResult performanceAudit(@RequestParam("performancesId") String performancesId, @RequestParam("status") int status, @RequestParam(value = "rejectTxt", required = false) String rejectTxt) {
        boolean result = kylinPerformancesService.performanceAudit(performancesId, status, rejectTxt);
        return toAjax(result);
    }

    //@RequiresPermissions("kylin:performances:view")
    @PostMapping(value = "/isShow")
    @ResponseBody
    public AjaxResult setIsShow(String performancesId, Integer isShow) {
        return toAjax(kylinPerformancesService.setIsShow(performancesId, isShow));
    }

    @Log(title = "演出列表", businessType = BusinessType.DETAIL)
    //@RequiresPermissions("kylin:performances:view")
    @GetMapping(value = "/memberInfo/{performancesId}")
    public String memberInfo(@PathVariable("performancesId") String performancesId, ModelMap mmap) {
        PerformanceMemberAuditDao result = kylinPerformancesService.performanceMemberInfo(performancesId);
        mmap.put("performanceMemberAuditDao", result);
        return prefix + "/memberInfo";
    }

    @Log(title = "演出列表", businessType = BusinessType.UPDATE)
    //@RequiresPermissions("kylin:performances:view")
    @PostMapping(value = "/memberInfo/submit")
    @ResponseBody
    public AjaxResult memberInfo(PerformanceMemberAuditParam performanceMemberAuditParam) {
        boolean result = kylinPerformancesService.performanceMemberChange(performanceMemberAuditParam);
        return toAjax(result);
    }

    @Log(title = "演出列表-演出数据", businessType = BusinessType.LIST)
    //@RequiresPermissions("kylin:performances:view")
    @GetMapping(value = "/performanceStatic/{performancesId}")
    public String performanceStatic(@PathVariable("performancesId") String performancesId, ModelMap mmap) {
        //获取演出详情
        KylinPerformanceMisVo performanceMisVo = kylinPerformancesService.performanceDetails(performancesId);

        List<PerformanceOrderStatisticalDao> result = kylinPerformancesService.getPerformanceOrderStatisticalList(performancesId);
        //构造top统计数据
        PerformanceOrderStatisCountResp perCountResp = new PerformanceOrderStatisCountResp();
        perCountResp.setPerformanceTitle(performanceMisVo.getTitle());
        if (result.size() >= 2) {
            PerformanceOrderStatisticalDao resdao = result.get(result.size() - 1);
            perCountResp.setTotalSalePrice(resdao.getTotalSalePrice());
            perCountResp.setSaleGeneral(resdao.getSaleGeneral());
            perCountResp.setTotalGeneral(resdao.getTotalGeneral());
            perCountResp.setTotalExchange(resdao.getTotalExchange());
            perCountResp.setSurplusExchange(resdao.getSurplusGeneral());
            perCountResp.setTotalBuyUsers(resdao.getTotalBuyUsers());
            perCountResp.setTotalDisPrice(BigDecimal.ONE);
            perCountResp.setTotalRefundGeneral(resdao.getTotalRefundGeneral());
        }

        mmap.put("perCountResp", perCountResp);
        mmap.put("perOrderStaticList", result);
        return prefix + "/performancesStatic";
    }

    //@RequiresPermissions("kylin:performances:view")
    @GetMapping(value = "/damai/{performancesId}")
    public String damai(@PathVariable("performancesId") String performancesId, ModelMap mmap) {
        KylinPerformanceDamaiVo result = kylinPerformancesService.getPerformanceDamai(performancesId);
        mmap.put("kylinPerformanceDamaiVo", result);
        return prefix + "/damai";
    }

    //@RequiresPermissions("kylin:performances:view")
    @GetMapping(value = "/agent/{performancesId}")
    public String agent(@PathVariable("performancesId") String performancesId, ModelMap mmap) {
        KylinPerformanceAgentVo result = kylinPerformancesService.getPerformanceAgent(performancesId);
        mmap.put("kylinPerformanceAgentVo", result);
        return prefix + "/agent";
    }

    //@RequiresPermissions("kylin:performances:view")
    @PostMapping(value = "/agent/change")
    @ResponseBody
    public AjaxResult changeTicketAgent(@RequestParam("performancesId") String performancesId, @RequestParam("ticketsId") String ticketsId, @RequestParam("status") Integer status) {
        boolean result = kylinPerformancesService.changeTicketAgent(performancesId, ticketsId, status);
        return toAjax(result);
    }

    //@RequiresPermissions("kylin:performances:view")
    @PostMapping(value = "/damai/change")
    @ResponseBody
    public AjaxResult changeSysDamai(@RequestParam("params") String params) {
        List<SysDamaiParam> data = JsonUtils.fromJson(params, new TypeReference<List<SysDamaiParam>>() {
        });
        boolean result = kylinPerformancesService.changeSysDamai(data);
        return toAjax(result);
    }

    //@RequiresPermissions("kylin:performances:view")
    @PostMapping(value = "/sync/damai")
    @ResponseBody
    public AjaxResult syncDamai(@RequestParam("performancesId") String performancesId) {
        boolean result = damaiService.sycPerformance(performancesId);
        return toAjax(result);
    }

    //@RequiresPermissions("kylin:performances:view")
    @GetMapping(value = "/refundConfig/{performancesId}")
    public String getRefundConfig(@PathVariable("performancesId") String performancesId, ModelMap mmap) {
        PerformanceRefundConfigVo result = kylinPerformancesService.getRefundConfig(performancesId);
        mmap.put("performanceRefundConfigVo", result);
        return prefix + "/refundConfig";
    }

    //@RequiresPermissions("kylin:performances:view")
    @PostMapping(value = "/refundConfig/change")
    @ResponseBody
    public AjaxResult changeRefundConfig(@RequestParam("performancesId") String performancesId,
                                         @RequestParam("isCanRefund") Integer isCanRefund,
                                         @RequestParam("refundOpenTime") String refundOpenTime,
                                         @RequestParam("refundCloseTime") String refundCloseTime,
                                         @RequestParam("isRefundPoundage") Integer isRefundPoundage,
                                         @RequestParam("isRefundVoucher") Integer isRefundVoucher,
                                         @RequestParam("isRefundExpress") Integer isRefundExpress) {
        boolean result = kylinPerformancesService.changeRefundConfig(performancesId,isCanRefund,refundOpenTime,refundCloseTime,isRefundPoundage,isRefundVoucher,isRefundExpress);
        return toAjax(result);
    }
}
