package com.liquidnet.service.goblin.dto.vo;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.io.Serializable;
import java.math.BigDecimal;

@Data
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "手环下单结果vo")
public class GoblinBraceletPayResultVo implements Serializable, Cloneable {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(position = 1, value = "订单ID")
    private String orderId;

    @ApiModelProperty(position = 3, value = "价格")
    private BigDecimal price;

    @ApiModelProperty(position = 5, value = "三方支付信息")
    private Object payInfo;


    private static final GoblinBraceletPayResultVo obj = new GoblinBraceletPayResultVo();

    public static GoblinBraceletPayResultVo getNew() {
        try {
            return (GoblinBraceletPayResultVo) obj.clone();
        } catch (CloneNotSupportedException e) {
            e.printStackTrace();
        }
        return new GoblinBraceletPayResultVo();
    }
}
