package com.liquidnet.service.platform.controller.stone;

import com.liquidnet.service.base.ResponseDto;
import com.liquidnet.service.platform.service.impl.stone.StoneServerImpl;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;


@Api(tags = "数据迁移 (会重复)")
@RestController
@RequestMapping("stone/inner")
public class InnerController {

    @Autowired
    private StoneServerImpl data;

    @PostMapping("initScore")
    @ApiOperation("会员卡领取积分")
    public void initScore(@RequestParam("uid") String uid) {
        data.initScore(uid);
//        return ResponseDto.success(result);
    }


    @PostMapping("refreshScore")
    @ApiOperation("积分过期")
    @ApiImplicitParams({
            @ApiImplicitParam(type = "form", required = true, dataType = "String", name = "time", value = "格式[2025-12-27]", example = "2025-12-27"),
    })
    public ResponseDto<Boolean> refreshScore(@RequestParam("time") String time) {
        boolean res = data.refreshScore(time);
        return ResponseDto.success(res);
    }

}
