package com.liquidnet.service.candy.controller;

import com.liquidnet.commons.lang.util.CollectionUtil;
import com.liquidnet.commons.lang.util.CurrentUtil;
import com.liquidnet.service.base.ResponseDto;
import com.liquidnet.service.candy.service.ICandyConsumerService;
import com.liquidnet.service.candy.service.ICandyCouponService;
import com.liquidnet.service.candy.vo.CandyCouponPreVo;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.ArrayList;
import java.util.List;

/**
 * <p>
 * 券消费 前端控制器
 * </p>
 *
 * @author liquidnet
 * @since 2021-08-18
 */
@RestController
@RequestMapping("/inner/candy-consumer")
public class CandyConsumerController {

    @Autowired
    private ICandyConsumerService candyConsumerService;

    @PostMapping("couponOrderBackRedis")
    @ApiOperation("AbstractCouponOrderBackRedisReceiver")
    @ApiImplicitParams({
            @ApiImplicitParam(type = "form", dataType = "String", name = "uid", value = "用户id", required = true),
            @ApiImplicitParam(type = "form", dataType = "String", name = "uCouponId", value = "券code", required = true),
    })
    public ResponseDto<Boolean> myCouponPre(String uid, String uCouponId) {
        ArrayList<String> uCouponIdList = CollectionUtil.arrayListString();
        uCouponIdList.add(uCouponId);
        return candyConsumerService.couponOrderBackRedis(uid, uCouponIdList);
    }
}
