package com.liquidnet.service.merchant.controller;

import com.github.xiaoymin.knife4j.annotations.ApiOperationSupport;
import com.github.xiaoymin.knife4j.annotations.ApiSupport;
import com.liquidnet.commons.lang.util.CurrentUtil;
import com.liquidnet.service.base.PagedResult;
import com.liquidnet.service.base.ResponseDto;
import com.liquidnet.service.merchant.dto.param.MerchantFieldApplyParam;
import com.liquidnet.service.merchant.dto.vo.MerchantFieldCheckersVo;
import com.liquidnet.service.merchant.dto.vo.MerchantFieldsVo;
import com.liquidnet.service.merchant.service.IMerchantFieldsAppliesService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;

import javax.validation.Valid;
import java.util.List;

/**
 * <p>
 * 场地表 前端控制器
 * </p>
 *
 * @author liquidnet
 * @since 2021-11-01
 */
@ApiSupport(order = 10010)
@Api(tags = "场地")
@Slf4j
@Validated
@RestController
@RequestMapping("fields")
public class MerchantFieldsController {

    @Autowired
    IMerchantFieldsAppliesService merchantFieldsAppliesService;

    @ApiOperationSupport(order = 10)
    @ApiOperation(value = "场地搜索")
    @GetMapping("search")
    public ResponseDto<PagedResult<MerchantFieldsVo>> search(@RequestParam(required = true) String name,
                                                             @RequestParam(defaultValue = "1", required = false) int page,
                                                             @RequestParam(defaultValue = "10", required = false) int size) {
        return ResponseDto.success(merchantFieldsAppliesService.search(name, page, size));
    }

    @ApiOperationSupport(order = 11)
    @ApiOperation(value = "申请场地")
    @PostMapping("apply")
    public ResponseDto<Object> apply(@Valid @RequestBody MerchantFieldApplyParam parameter) {
        String currentUid = CurrentUtil.getCurrentUid();

        return ResponseDto.success(merchantFieldsAppliesService.apply(currentUid, parameter));
    }

    @ApiOperationSupport(order = 12)
    @ApiOperation(value = "更改场地是否审核演出")
    @PostMapping("editIsCheck")
    public ResponseDto<Object> editIsCheck(@RequestParam(required = true) String fieldId,
                                           @RequestParam(required = true) int isCheck){
        String currentUid = CurrentUtil.getCurrentUid();

        merchantFieldsAppliesService.editIsCheck(currentUid, fieldId, isCheck);

        return ResponseDto.success();
    }

    @ApiOperationSupport(order = 13)
    @ApiOperation(value = "默认验票员列表")
    @GetMapping("checkers")
    public ResponseDto<List<MerchantFieldCheckersVo>> checkers(@RequestParam(required = true) String fieldId) {
        String currentUid = CurrentUtil.getCurrentUid();
        
        return ResponseDto.success(merchantFieldsAppliesService.checkers(currentUid, fieldId));
    }

    @ApiOperationSupport(order = 14)
    @ApiOperation(value = "添加默认验票员")
    @PostMapping("checker/add")
    public ResponseDto<Object> checkerAdd(@RequestParam(required = true) String fieldId,
                                          @RequestParam(required = true) String uid,
                                          @RequestParam(required = true) String mobile,
                                          @RequestParam(required = true) String name){
        String currentUid = CurrentUtil.getCurrentUid();

        merchantFieldsAppliesService.checkerAdd(currentUid, fieldId, uid, mobile, name);

        return ResponseDto.success();
    }

    @ApiOperationSupport(order = 15)
    @ApiOperation(value = "移除默认验票员")
    @PostMapping("checker/del")
    public ResponseDto<Object> checkerDel(@RequestParam(required = true) String fieldId,
                                          @RequestParam(required = true) String uid){
        String currentUid = CurrentUtil.getCurrentUid();

        merchantFieldsAppliesService.checkerDel(currentUid, fieldId, uid);

        return ResponseDto.success();
    }
}
