package com.liquidnet.service.goblin.dto.vo;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.liquidnet.commons.lang.util.DateUtil;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDateTime;

@ApiModel(value = "GoblinShowStoreInfoVo", description = "店铺基础信息[前端显示]")
@Data
public class GoblinShowStoreInfoVo implements Serializable, Cloneable {
    private static final long serialVersionUID = -2268722236055938975L;
    @ApiModelProperty(position = 11, value = "店铺ID[64]")
    private String storeId;
    @ApiModelProperty(position = 13, value = "店铺名称[128]")
    private String storeName;
    @ApiModelProperty(position = 14, value = "店铺LOGO[256]")
    private String logoPic;
    @ApiModelProperty(position = 15, value = "店铺背景图[256]")
    private String backgroundPic;
    @ApiModelProperty(position = 16, value = "店铺介绍[500]")
    private String introduce;
    @ApiModelProperty(position = 17, value = "店铺状态[0-填写资料中|1-店铺审核中|2-审核不通过|3-审核通过|4-停业|5-营业]")
    private String status;
    @ApiModelProperty(position = 19, value = "店铺类型[1-普通店铺|2-加盟|3-连锁|5-直营]")
    private String storeType;
    @ApiModelProperty(position = 20, value = "认证类型[1-企业/公司|2-个体工商户]")
    private String certType;
    @ApiModelProperty(position = 21, value = "店铺评分[8,2]")
    private BigDecimal aveScore;
    @ApiModelProperty(position = 22, value = "客服账号[128]")
    private String serviceAcc;
    @ApiModelProperty(position = 23, value = "店铺有效期")
    private String createdBy;
    @JsonFormat(shape=JsonFormat.Shape.STRING, pattern= DateUtil.DATE_FULL_STR)
    private LocalDateTime createdAt;

    private static final GoblinShowStoreInfoVo obj = new GoblinShowStoreInfoVo();

    public static GoblinShowStoreInfoVo getNew() {
        try {
            return (GoblinShowStoreInfoVo) obj.clone();
        } catch (CloneNotSupportedException e) {
            return new GoblinShowStoreInfoVo();
        }
    }
}
