package com.liquidnet.service.kylin.service.impl;

import com.github.pagehelper.PageInfo;
import com.liquidnet.common.cache.redis.util.RedisUtil;
import com.liquidnet.commons.lang.util.CurrentUtil;
import com.liquidnet.service.adam.dto.vo.admin.AdminUpushVo;
import com.liquidnet.service.kylin.constant.KylinRedisConst;
import com.liquidnet.service.kylin.dto.vo.KylinPerformanceSubscribeUpushVo;
import com.liquidnet.service.kylin.utils.DataUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import javax.servlet.http.HttpServletRequest;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Iterator;
import java.util.LinkedList;

/**
 * <p>
 * 轮播图 服务实现类
 * </p>
 *
 * @author jiangxiulong
 * @since 2021-05-02
 */
@Service
public class KylinUpushServiceImpl {

    @Value("${liquidnet.aliyun.oss.imgUrl}")
    private String imgUrl;

    @Autowired
    MongoTemplate mongoTemplate;

    @Autowired
    private RedisUtil redisUtil;

    @Autowired
    private DataUtils dataUtils;

    public PageInfo<AdminUpushVo> lists(HttpServletRequest request, Integer page, Integer size) {
        String uid = CurrentUtil.getCurrentUid();
        String source = request.getHeader("source");
        PageInfo<AdminUpushVo> voPageInfo = null;
        Object adminUpushVo = null;
        if (null != source) {
            if (source.equals("IOS")) {
                adminUpushVo = redisUtil.get(KylinRedisConst.ADMIN_UPUSH_LIST_IOS);
            } else if (source.equals("Android")) {
                adminUpushVo = redisUtil.get(KylinRedisConst.ADMIN_UPUSH_LIST_ANDROID);
            }
        }
        if (null == adminUpushVo || page > 1) { // 不分页了 大于第一页返回空
            voPageInfo = PageInfo.of(new LinkedList<>());
        } else {
            LinkedList<AdminUpushVo> pushList = (LinkedList<AdminUpushVo>) adminUpushVo;
            Integer num = 0;
            for (Iterator<AdminUpushVo> it = pushList.iterator(); it.hasNext(); ) {
                AdminUpushVo info = it.next();
                String pushTime = info.getPushTime();
                DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
                LocalDateTime pushTimeL = LocalDateTime.parse(pushTime, formatter);
                if (pushTimeL.isAfter(LocalDateTime.now())) {
                    it.remove();
                    continue;
                }
                if (num == 0) {
                    redisUtil.set(KylinRedisConst.ADMIN_UPUSH_LIST_READ_UID.concat(uid), info.getUpushId());
                }
                num++;
                if (!info.getImg().isEmpty()) {
                    String img = imgUrl + info.getImg();
                    info.setImg(img);
                }
            }
            voPageInfo = PageInfo.of(pushList);
            voPageInfo.setTotal(pushList.size());
        }
        return voPageInfo;
    }

    public Integer unread(HttpServletRequest request) {
        String uid = CurrentUtil.getCurrentUid();
        Object obj = redisUtil.get(KylinRedisConst.ADMIN_UPUSH_LIST_READ_UID.concat(uid));

        String source = request.getHeader("source");
        Object adminUpushVo = null;
        if (null != source) {
            if (source.equals("IOS")) {
                adminUpushVo = redisUtil.get(KylinRedisConst.ADMIN_UPUSH_LIST_IOS);
            } else if (source.equals("Android")) {
                adminUpushVo = redisUtil.get(KylinRedisConst.ADMIN_UPUSH_LIST_ANDROID);
            }
        }

        if (null == adminUpushVo || null == source) {
            return 0;
        }

        LinkedList<AdminUpushVo> pushList = (LinkedList<AdminUpushVo>) adminUpushVo;

        if (null == obj) {
            return pushList.size();
        }

        Integer num = 0;
        String pushId = (String) obj;
        for (Iterator<AdminUpushVo> it = pushList.iterator(); it.hasNext(); ) {
            AdminUpushVo info = it.next();
            if (info.getUpushId().equals(pushId)) {
                break;
            } else {
                String pushTime = info.getPushTime();
                DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
                LocalDateTime pushTimeL = LocalDateTime.parse(pushTime, formatter);
                if (pushTimeL.isBefore(LocalDateTime.now())) {
                    num++;
                }
            }
        }
        return num;
    }
    
    /**
     * 开票提醒消息列表
     * @author zjp
     * @return: java.util.LinkedList<com.liquidnet.service.kylin.dto.vo.KylinPerformanceSubscribeUpushVo>
     * @date 2024/3/14 14:53
    */
    public LinkedList<KylinPerformanceSubscribeUpushVo> billingReminderList(){
        String uid = CurrentUtil.getCurrentUid();
        LinkedList<KylinPerformanceSubscribeUpushVo> performanceSubscribeList = dataUtils.getPerformanceSubscribeList(uid);
        if(!CollectionUtils.isEmpty(performanceSubscribeList)){
            for (Iterator<KylinPerformanceSubscribeUpushVo> it = performanceSubscribeList.iterator(); it.hasNext(); ) {
                KylinPerformanceSubscribeUpushVo info = it.next();
                //剔除推送时间比当前时间大的数据
                String pushTime = info.getPushTime();
                DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
                LocalDateTime pushTimeL = LocalDateTime.parse(pushTime, formatter);
                if(pushTimeL.isAfter(LocalDateTime.now())){
                    it.remove();
                    continue;
                }
                //设置当前消息用户已读
                dataUtils.setPerformanceSubscribeRead(uid,info.getPerformancesId(),info.getTicketTimesId());
            }
        }
        return performanceSubscribeList;
    }

    public Integer billingReminderUnread(){
        int num=0;
        String uid = CurrentUtil.getCurrentUid();
        LinkedList<KylinPerformanceSubscribeUpushVo> performanceSubscribeList = dataUtils.getPerformanceSubscribeList(uid);
        if(!CollectionUtils.isEmpty(performanceSubscribeList)){
            for (Iterator<KylinPerformanceSubscribeUpushVo> it = performanceSubscribeList.iterator(); it.hasNext(); ) {
                KylinPerformanceSubscribeUpushVo info = it.next();
                //剔除推送时间比当前时间大的数据
                String pushTime = info.getPushTime();
                DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
                LocalDateTime pushTimeL = LocalDateTime.parse(pushTime, formatter);
                if(pushTimeL.isAfter(LocalDateTime.now())){
                    it.remove();
                    continue;
                }
                //判断当前用户消息是否已读
                Integer performanceSubscribeRead = dataUtils.getPerformanceSubscribeRead(uid, info.getPerformancesId(), info.getTicketTimesId());
                if(performanceSubscribeRead==0){
                    num++;
                }
            }
        }
        return num;
    }
}
