package com.liquidnet.service.controller;

import com.liquidnet.common.cache.redis.util.RedisUtil;
import com.liquidnet.service.base.ResponseDto;
import com.liquidnet.service.goblin.constant.SmileRedisConst;
import com.liquidnet.service.goblin.dto.vo.SmileAgentVo;
import com.liquidnet.service.goblin.dto.vo.SmileUserVO;
import com.liquidnet.service.goblin.service.manage.SmileFrontService;
import com.liquidnet.service.kylin.constant.KylinRedisConst;
import com.liquidnet.service.util.SmileRedisUtils;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

/**
 * @author zhangfuxin
 * @Description:用户接口
 * @date 2021/12/27 下午6:25
 */
@Api(tags = "前端接口管理(不需要登陆)")
@RestController
@RequestMapping("/frontNoLogin")
@Slf4j
public class SmileNoLoginController {
    @Autowired
    private RedisUtil redisUtil;
    @Autowired
    private SmileRedisUtils smileRedisUtils;
    @Autowired
    private SmileFrontService smileFrontService;

    @PostMapping("getUser")
    @ApiOperation("获取用户状态,并返回票提")
    public ResponseDto<SmileUserVO> getUser(String userId, String performanceId, String ticketId) {
        SmileUserVO smileUserVO = (SmileUserVO) redisUtil.get(SmileRedisConst.SMILE_USER.concat(userId));
        if(null!=smileUserVO){
            SmileAgentVo smileAgentVo=null;
            if(smileUserVO.getType()==5){
                 smileAgentVo = (SmileAgentVo) redisUtil.get(SmileRedisConst.SMILE_AGENT.concat(performanceId).concat(":").concat(userId));
            }else{
                 smileAgentVo = (SmileAgentVo) redisUtil.get(SmileRedisConst.SMILE_AGENT.concat(performanceId).concat(":").concat(ticketId));
            }
            smileUserVO.setSmileAgentVo(smileAgentVo);
        }
        return ResponseDto.success(smileUserVO);
    }
    @PostMapping("getUserById")
    @ApiOperation("获取用户状态,返回用户")
    public ResponseDto<SmileUserVO> getUserById(@RequestParam("userId") String userId) {
        try {
            SmileUserVO smileUserVO = smileRedisUtils.getSmileUserVo(userId);
            if (smileUserVO == null) {
                Object nameObj = redisUtil.getRedisTemplateByDb(15)
                        .opsForHash()
                        .get(KylinRedisConst.PERFORMANCES_AGENT_INFO + userId, "name");
                smileUserVO = SmileUserVO.getNew();
                if (nameObj != null) {
                    smileUserVO.setName(String.valueOf(nameObj));
                    smileUserVO.setState(0);
                } else {
                    smileUserVO.setName("");
                }
            }
            return ResponseDto.success(smileUserVO);
        } catch (Exception e) {
            log.error("小家伙详情Error", e);
            SmileUserVO smileUserVO = SmileUserVO.getNew();
            smileUserVO.setName("");
            return ResponseDto.success(smileUserVO);
        }
    }


}
