package com.liquidnet.service.account.funding.dto;

import com.liquidnet.service.account.funding.dto.base.FundingCallParam;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

/**
 * FundingRegisterParam.class
 *
 * @author zhanggb
 * Created by IntelliJ IDEA at 2020/10/20
 */
@ApiModel(value = "FundingRegisterParam", description = "Parameters of funding account register")
public class FundingRegisterParam extends FundingCallParam {
    private static final long serialVersionUID = 3943234839566753953L;
    @ApiModelProperty(position = 11, required = true, value = "Funding currency alphabetic code [5]", example = "USD")
    private String currency;
    @ApiModelProperty(position = 12, required = false, value = "Funding account Alias [100]", example = "184001")
    private String accAlias;
    @ApiModelProperty(position = 13, required = true, value = "Wallet user ID [32]", example = "1001")
    private String finId;
    @ApiModelProperty(position = 14, required = true, value = "Funding account type [5]", example = "000")
    private String accType;
    @ApiModelProperty(position = 15, required = true, value = "Group ID [32]", example = "18400000001")
    private String accGroupId;

    public String getCurrency() {
        return currency;
    }

    public void setCurrency(String currency) {
        this.currency = currency;
    }

    public String getAccAlias() {
        return accAlias;
    }

    public void setAccAlias(String accAlias) {
        this.accAlias = accAlias;
    }

    public String getFinId() {
        return finId;
    }

    public void setFinId(String finId) {
        this.finId = finId;
    }

    public String getAccGroupId() {
        return accGroupId;
    }

    public void setAccGroupId(String accGroupId) {
        this.accGroupId = accGroupId;
    }

    public String getAccType() {
        return accType;
    }

    public void setAccType(String accType) {
        this.accType = accType;
    }
}
