package com.liquidnet.service.sweet.dto;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.util.List;

@Data
@ApiModel
public class SweetPerformArtistTimeListDto implements Serializable, Cloneable {

    private static final long serialVersionUID = 1285742725281098300L;

    @ApiModelProperty("演出日期")
    private String startTime;
    @ApiModelProperty("舞台数据")
    private List<SweetManualArtistStageListArDto> stageList;

    private static final SweetPerformArtistTimeListDto obj = new SweetPerformArtistTimeListDto();

    public static SweetPerformArtistTimeListDto getNew() {
        try {
            return (SweetPerformArtistTimeListDto) obj.clone();
        } catch (CloneNotSupportedException e) {
            return new SweetPerformArtistTimeListDto();
        }
    }
}
