package com.liquidnet.client.admin.zhengzai.slime.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.liquidnet.client.admin.common.utils.bean.BeanUtils;
import com.liquidnet.client.admin.zhengzai.slime.service.ISlimeSponsorsAdminService;
import com.liquidnet.client.admin.zhengzai.slime.utils.SlimeMongoUtil;
import com.liquidnet.client.admin.zhengzai.slime.utils.SlimeRedisUtil;
import com.liquidnet.common.exception.LiquidnetServiceException;
import com.liquidnet.service.slime.dto.param.admin.SlimeSponsorEditParam;
import com.liquidnet.service.slime.dto.vo.SlimeSponsorsVo;
import com.liquidnet.service.slime.entity.SlimeSponsors;
import com.liquidnet.service.slime.mapper.SlimeSponsorsMapper;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.time.LocalDateTime;

@Slf4j
@Service
public class SlimeSponsorsAdminServiceImpl extends ServiceImpl<SlimeSponsorsMapper, SlimeSponsors> implements ISlimeSponsorsAdminService {

    @Autowired
    SlimeRedisUtil slimeRedisUtil;

    @Autowired
    SlimeMongoUtil slimeMongoUtil;

    @Override
    public boolean sponsorEdit(SlimeSponsorEditParam parameter) {
        LocalDateTime now = LocalDateTime.now();

        // 查询主办 entity
        LambdaQueryWrapper<SlimeSponsors> sponsorsLambdaQueryWrapper = Wrappers.lambdaQuery(SlimeSponsors.class);
        sponsorsLambdaQueryWrapper.eq(SlimeSponsors::getSponsorId, parameter.getSponsorId());
        SlimeSponsors sponsorsEntity = getOne(sponsorsLambdaQueryWrapper);
        if (null == sponsorsEntity) {
            throw new LiquidnetServiceException();
        }

        // 主办 entity
        BeanUtils.copyProperties(parameter, sponsorsEntity);
        sponsorsEntity.setUpdatedAt(now);

        // 主办 mysql
        updateById(sponsorsEntity);

        // 主办 vo
        SlimeSponsorsVo sponsorsVo = SlimeSponsorsVo.getNew();
        sponsorsVo.copy(sponsorsEntity);

        // 主办 mongo
        slimeMongoUtil.setSponsorsVoBySponsorId(sponsorsVo.getSponsorId(), sponsorsVo);

        // 主办 redis
        slimeRedisUtil.setSponsorsVoBySponsorId(sponsorsVo.getSponsorId(), sponsorsVo);

        return true;
    }
}
