package com.liquidnet.service.dragon.channel.douyinpay.strategy;

import org.springframework.stereotype.Component;

import java.util.HashMap;
import java.util.Map;

/**
 * @author zhangfuxin
 * @Description:
 * @date 2021/11/9 下午4:09
 */
@Component
public class DouYinayStrategyContext {
    private final Map<String, IDouYinpayStrategy> handlerMap = new HashMap<>();

    public IDouYinpayStrategy getStrategy(String type) {
        return handlerMap.get(type);
    }

    public void putStrategy(String code, IDouYinpayStrategy strategy) {
        handlerMap.put(code, strategy);
    }
}
