package com.liquidnet.service.adam.dto.vo;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

@ApiModel(value = "AdamUserInfoSimpleVo", description = "用户简易信息")
@Data
public class AdamUserInfoSimpleVo implements java.io.Serializable, Cloneable {
    private static final long serialVersionUID = 8479869354894030303L;
    @ApiModelProperty(position = 10, value = "用户ID[64]")
    private String uid;
    @ApiModelProperty(position = 11, value = "手机号[20]")
    private String mobile;
    @ApiModelProperty(position = 14, value = "昵称[32]")
    private String nickname;
    @ApiModelProperty(position = 15, value = "头像")
    private String avatar;


    private static final AdamUserInfoSimpleVo obj = new AdamUserInfoSimpleVo();

    public static AdamUserInfoSimpleVo getNew() {
        try {
            return (AdamUserInfoSimpleVo) obj.clone();
        } catch (CloneNotSupportedException e) {
            e.printStackTrace();
        }
        return new AdamUserInfoSimpleVo();
    }
}
