package com.liquidnet.service.sweet.dto.param.admin;

import com.liquidnet.service.sweet.entity.SweetIntegralActivityPrizeRelation;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotBlank;
import java.io.Serializable;

/**
 * <p>
 * SweetIntegralActivityPrizeRelationFormParam
 * </p>
 *
 * @author jiangxiulong
 * @since 2021-12-02
 */

@Data
@ApiModel(value = "SweetIntegralActivityPrizeRelationFormParam", description = "积分活动创建奖品入参")
public class SweetIntegralActivityPrizeRelationFormParam implements Serializable, Cloneable {

    private static final long serialVersionUID = -4381851476183020667L;

    @ApiModelProperty(value = "活动主键id", example = "429803743878963206506461")
    @NotBlank(message = "integralActivityId不能为空")
    private String integralActivityId;

    @ApiModelProperty(value = "奖品主键id", example = "429803743878963206506461")
    @NotBlank(message = "prizeId不能为空")
    private String prizeId;

    @ApiModelProperty(value = "券id", example = "429803743878963206506461")
    @NotBlank(message = "couponId不能为空")
    private String couponId;

    @ApiModelProperty(value = "券名称", example = "优惠券")
    @NotBlank(message = "couponTitle不能为空")
    private String couponTitle;


    private static final SweetIntegralActivityPrizeRelationFormParam obj = new SweetIntegralActivityPrizeRelationFormParam();

    public static SweetIntegralActivityPrizeRelationFormParam getNew() {
        try {
            return (SweetIntegralActivityPrizeRelationFormParam) obj.clone();
        } catch (CloneNotSupportedException e) {
            return new SweetIntegralActivityPrizeRelationFormParam();
        }
    }

    public SweetIntegralActivityPrizeRelation copy(SweetIntegralActivityPrizeRelationFormParam source) {
        SweetIntegralActivityPrizeRelation activityPrizeRelation = SweetIntegralActivityPrizeRelation.getNew();
        if (null == source) return null;
        activityPrizeRelation.setPrizeId(source.getPrizeId());
        activityPrizeRelation.setCouponId(source.getCouponId());
        activityPrizeRelation.setCouponTitle(source.getCouponTitle());
        return activityPrizeRelation;
    }

}