package com.liquidnet.service.goblin.controller;

import com.liquidnet.service.base.ResponseDto;
import com.liquidnet.service.goblin.dto.vo.GoblinRechargeWristbandVo;
import com.liquidnet.service.goblin.service.IGoblinRechargeWristbandService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Slf4j
@Api(tags = "充值金额")
@RestController
@Validated
@RequestMapping("/recharge/goods")
public class GoblinRechargeAmountController {

    @Autowired
    private IGoblinRechargeWristbandService iGoblinRechargeWristbandService;


    @GetMapping("list")
    @ApiOperation("获得金额列表")
    public ResponseDto<GoblinRechargeWristbandVo> getList() {
        return ResponseDto.success(iGoblinRechargeWristbandService.getList());
    }

}
