package com.liquidnet.service.adam.dto.vo;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.List;

@ApiModel(value = "AdamRscPolymer01Vo", description = "票务下单所需信息")
@Data
public class AdamRscPolymer01Vo implements java.io.Serializable, Cloneable {
    private static final long serialVersionUID = -4945093532123934888L;
    @ApiModelProperty(position = 1, value = "标记[0-普通用户｜2-过期会员｜10-老会员｜11-新会员]")
    private int membership;
    @ApiModelProperty(position = 2, value = "收货地址")
    private AdamAddressesVo addressesVo;
    @ApiModelProperty(position = 3, value = "入场人列表")
    private List<AdamEntersVo> entersVos;

    private static final AdamRscPolymer01Vo obj = new AdamRscPolymer01Vo();

    public static AdamRscPolymer01Vo getNew() {
        try {
            return (AdamRscPolymer01Vo) obj.clone();
        } catch (CloneNotSupportedException e) {
            return new AdamRscPolymer01Vo();
        }
    }
}
