package com.liquidnet.client.admin.zhengzai.kylin.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.liquidnet.client.admin.common.utils.StringUtils;
import com.liquidnet.client.admin.zhengzai.kylin.service.InnerService;
import com.liquidnet.client.admin.zhengzai.kylin.utils.DataUtils;
import com.liquidnet.client.admin.zhengzai.kylin.utils.PerformanceVoUtils;
import com.liquidnet.client.admin.zhengzai.slime.service.ISlimeAuthorizationRecordsAdminService;
import com.liquidnet.client.admin.zhengzai.smile.utils.SmileRedisUtils;
import com.liquidnet.commons.lang.util.BeanUtil;
import com.liquidnet.commons.lang.util.CollectionUtil;
import com.liquidnet.commons.lang.util.DateUtil;
import com.liquidnet.service.goblin.dto.vo.SmileAgentVo;
import com.liquidnet.service.kylin.constant.KylinRedisConst;
import com.liquidnet.service.kylin.dao.*;
import com.liquidnet.service.kylin.dao.report.KylinPerformanceSubscribeTicketStatisticalDao;
import com.liquidnet.service.kylin.dto.param.*;
import com.liquidnet.service.kylin.dto.vo.admin.*;
import com.liquidnet.service.kylin.dto.vo.mongo.KylinOrderTicketEntitiesVo;
import com.liquidnet.service.kylin.dto.vo.mongo.KylinOrderTicketVo;
import com.liquidnet.service.kylin.dto.vo.mongo.KylinPerformanceVo;
import com.liquidnet.service.kylin.dto.vo.partner.KylinPerformanceMisVo;
import com.liquidnet.service.kylin.dto.vo.partner.KylinTicketPartnerVo;
import com.liquidnet.service.kylin.dto.vo.partner.KylinTicketTimesPartnerVo;
import com.liquidnet.service.kylin.dto.vo.partner.TicketTimesTicketCreatePartnerVo;
import com.liquidnet.service.kylin.entity.*;
import com.liquidnet.service.kylin.mapper.*;
import com.liquidnet.service.kylin.service.admin.IKylinPerformancesAdminService;
import com.liquidnet.service.smile.entity.SmileAgent;
import com.liquidnet.service.smile.mapper.SmileAgentMapper;
import com.mongodb.BasicDBObject;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.convert.MongoConverter;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.stereotype.Service;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

import static com.liquidnet.commons.lang.util.DateUtil.DTF_YMD_HMS;

/**
 * <p>
 * 演出 服务实现类
 * </p>
 *
 * @author liquidnet
 * @since 2021-05-05
 */
@Service
@Slf4j
public class KylinPerformancesAdminServiceImpl extends ServiceImpl<KylinPerformancesMapper, KylinPerformances> implements IKylinPerformancesAdminService {

    @Autowired
    MongoTemplate mongoTemplate;
    @Autowired
    private MongoConverter mongoConverter;
    @Autowired
    private PerformanceVoUtils performanceVoUtils;
    @Autowired
    private DataUtils dataUtils;
    @Autowired
    private KylinPerformancesMapper performancesMapper;
    @Autowired
    private KylinPerformanceStatusMapper performanceStatusMapper;
    @Autowired
    private KylinPerformanceRelationsMapper performanceRelationsMapper;
    @Autowired
    private KylinTicketsMapper ticketsMapper;
    @Autowired
    private KylinTicketStatusMapper ticketStatusMapper;
    @Autowired
    private KylinOrderTicketsMapper kylinOrderTicketsMapper;
    @Autowired
    private KylinOrderImportMapper orderImportMapper;
    @Autowired
    ISlimeAuthorizationRecordsAdminService merchantAuthorizationRecordsAdminService;
    @Autowired
    InnerService innerService;
    @Autowired
    private KylinOrderRefundsMapper kylinOrderRefundsMapper;

    @Autowired
    SmileRedisUtils smileRedisUtils;

    @Autowired
    SmileAgentMapper smileAgentMapper;

    @Autowired
    KylinPerformancesMapper kylinPerformancesMapper;

    @Override
    public void test() {
//        //同步演出
        String performancesId = "2020170834697011205072651";
        KylinPerformances data = performancesMapper.selectOne(new QueryWrapper<KylinPerformances>().in("performances_id", performancesId));
//        KylinPerformanceRelations relationData = performanceRelationsMapper.selectOne(new QueryWrapper<KylinPerformanceRelations>().in("performance_id", performancesId));
        //同步场地
//        innerService.reportField(dataUtils.getFieldsVoByFieldId(relationData.getFieldId()));
//        同步演出
        innerService.reportP(dataUtils.getPerformanceVo(performancesId), null, data.getSponsorId());
        //退款订单
//        String orderId = "2411921318065766408847583";
//        innerService.reportRefund(orderId, "R" + orderId, "测试");
        //同步订单
//        innerService.reportO(dataUtils.getOrderTicketVo(orderId),"摩登天空");
        log.info("SUCCESS");
    }

    @Override
    public boolean syncTicketSysPerformance(String performanceId) {
        //同步场地
        KylinPerformanceRelations relationData = performanceRelationsMapper.selectOne(new QueryWrapper<KylinPerformanceRelations>().in("performance_id", performanceId));
        boolean filedResult = innerService.reportField(dataUtils.getFieldsVoByFieldId(relationData.getFieldId()));
        if (!filedResult) {
            log.error("同步 场地 到票务平台 异常");
            return filedResult;
        }
        //同步演出
        KylinPerformances data = performancesMapper.selectOne(new QueryWrapper<KylinPerformances>().in("performances_id", performanceId));
        List<String> sessionCodeList = innerService.reportP(dataUtils.getPerformanceVo(performanceId), null, data.getSponsorId());

        if (!sessionCodeList.isEmpty()) {
            return true;
        }
        log.error("同步 演出 到票务平台 异常");
        return false;
    }

    @Override
    public boolean syncTicketSysOrder(String performanceId) {
        //查询演出下需要同步的订单id
        List<String> orderIds = kylinOrderTicketsMapper.getPayOrderIds(performanceId);
        boolean orderResult = true;
        for (String orderId : orderIds) {
            orderResult = innerService.reportO(dataUtils.getOrderTicketVo(orderId), "摩登天空");
            if (!orderResult) {
                log.error("同步 订单 到票务平台 异常 订单Id:{}", orderId);
                break;
            }
        }
        return orderResult;
    }

    @Override
    public KylinPerformanceMisVo performanceDetails(String performancesId) {
        log.info(" PERFORMANCE  mis演出详情");
        KylinPerformanceMisVo createMisVo = performanceVoUtils.getPerformanceMisVo(performancesId, null);
        return createMisVo;
    }

    @Override
    public boolean performanceAudit(String performancesId, int status, String rejectTxt) {
        try {
            LocalDateTime updatedAt = LocalDateTime.now();
            HashMap<String, Object> map = new HashMap<>();
            int auditStatus = 0;
            if (status == 3) {
                log.info(" PERFORMANCE  演出审核 通过");
                rejectTxt = "";
                auditStatus = 1;
                //修改演出
                map.put("rejectTxt", rejectTxt);
                map.put("status", status);
                map.put("auditStatus", auditStatus);
                map.put("updatedAt", updatedAt.format(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss")));
                BasicDBObject objectPerformanceVo = new BasicDBObject("$set", mongoConverter.convertToMongoType(map));
                mongoTemplate.getCollection(PerformancePartnerVo.class.getSimpleName()).updateOne(
                        Query.query(Criteria.where("performancesId").is(performancesId)).getQueryObject(),
                        objectPerformanceVo
                );

                KylinPerformanceStatus sqlStatus = performanceStatusMapper.selectOne(new UpdateWrapper<KylinPerformanceStatus>().eq("performance_id", performancesId));
                dataUtils.setPerformanceIsTrueName(performancesId, sqlStatus.getIsTrueName());
                if (sqlStatus.getStatus() == 1) {
                    log.info(" PERFORMANCE  演出审核 第一次");
                    //修改
                    KylinPerformanceStatus performanceStatus = new KylinPerformanceStatus();
                    performanceStatus.setStatus(status);
                    performanceStatus.setAuditStatus(auditStatus);
                    performanceStatus.setUpdatedAt(updatedAt);
                    performanceStatusMapper.update(performanceStatus, new UpdateWrapper<KylinPerformanceStatus>().eq("performance_id", performancesId));
                    KylinPerformances performances = new KylinPerformances();
                    performances.setUpdatedAt(updatedAt);
                    performances.setRejectTxt(rejectTxt);
                    performancesMapper.update(performances, new UpdateWrapper<KylinPerformances>().eq("performances_id", performancesId));

                    List<KylinTicketTimesPartnerVo> kylinTicketTimesPartnerVos = performanceVoUtils.getTimesMongoList(performancesId);
                    for (KylinTicketTimesPartnerVo ticketTimeItem : kylinTicketTimesPartnerVos) {
                        for (KylinTicketPartnerVo ticketItem : performanceVoUtils.getTicketMongoList(ticketTimeItem.getTicketTimesId())) {
                            BasicDBObject objectTicketVo = new BasicDBObject("$set", mongoConverter.convertToMongoType(map));
                            mongoTemplate.getCollection(KylinTicketPartnerVo.class.getSimpleName()).updateOne(
                                    Query.query(Criteria.where("ticketsId").is(ticketItem.getTicketsId())).getQueryObject(),
                                    objectTicketVo
                            );
                            KylinTickets tickets = new KylinTickets();
                            tickets.setUpdatedAt(updatedAt);
                            ticketsMapper.update(tickets, new UpdateWrapper<KylinTickets>().eq("tickets_id", ticketItem.getTicketsId()));
                            KylinTicketStatus ticketStatus = new KylinTicketStatus();
                            ticketStatus.setUpdatedAt(updatedAt);
                            ticketStatus.setStatus(status);
                            dataUtils.setTEMVo(ticketItem.getTicketsId(), dataUtils.getTEMMerchantVo(ticketItem.getTicketsId()));
                            ticketStatusMapper.update(ticketStatus, new UpdateWrapper<KylinTicketStatus>().eq("ticket_id", ticketItem.getTicketsId()));
                        }
                    }
                    performanceVoUtils.performanceVoStatus(performancesId);
//                    同步演出
//                    innerService.reportP(dataUtils.getPerformanceVo(performancesId), null, null);
                } else { //只修改演出相关 场次 票 (不包括 库存 售卖时间 限购)
                    log.info(" PERFORMANCE  演出审核 修改");

                    HashMap<String, Object> mapSql = new HashMap<>();
                    mapSql.put("status", 9);
                    mapSql.put("updatedAt", updatedAt.format(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss")));
                    KylinPerformanceMisVo vo = performanceVoUtils.getPerformanceMisVo(performancesId, "0");
                    performanceVoUtils.updatePerformanceMySql(performancesId, mapSql, vo, updatedAt, auditStatus);
//                    if (sqlStatus.getStatus() >= 6 && sqlStatus.getStatus() != 7) {//若 演出上 则 线判断状态
                    performanceVoUtils.performanceVoStatus(performancesId);
//                    }
                    delOrderTicketsRedis(vo);
                }
                dataUtils.delPerformanceRedis(performancesId);
                //权限
                KylinPerformances data = performancesMapper.selectOne(new QueryWrapper<KylinPerformances>().in("performances_id", performancesId));
                KylinPerformanceRelations relationData = performanceRelationsMapper.selectOne(new QueryWrapper<KylinPerformanceRelations>().in("performance_id", performancesId));
                merchantAuthorizationRecordsAdminService.authorizationInit(performancesId, relationData.getMerchantId(), relationData.getFieldId(), data.getSponsorId());
            } else if (status == 4) {
                log.info(" PERFORMANCE  演出审核 拒绝");
                auditStatus = 2;
                map.put("rejectTxt", rejectTxt);
                map.put("auditStatus", auditStatus);
                map.put("status", status);
                map.put("updatedAt", updatedAt.format(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss")));
                BasicDBObject object = new BasicDBObject("$set", mongoConverter.convertToMongoType(map));
                mongoTemplate.getCollection(PerformancePartnerVo.class.getSimpleName()).updateOne(
                        Query.query(Criteria.where("performancesId").is(performancesId)).getQueryObject(),
                        object
                );

                KylinPerformanceStatus statusData = performanceStatusMapper.selectOne(new UpdateWrapper<KylinPerformanceStatus>().eq("performance_id", performancesId));
                KylinPerformanceStatus performanceStatus = new KylinPerformanceStatus();
                if (statusData.getStatus() == 1 || statusData.getStatus() == 4) {
                    performanceStatus.setStatus(status);
                }
                performanceStatus.setAuditStatus(auditStatus);
                performanceStatus.setUpdatedAt(updatedAt);
                performanceStatusMapper.update(performanceStatus, new UpdateWrapper<KylinPerformanceStatus>().eq("performance_id", performancesId));

                KylinPerformances performances = new KylinPerformances();
                performances.setRejectTxt(rejectTxt);
                performances.setUpdatedAt(updatedAt);
                performancesMapper.update(performances, new UpdateWrapper<KylinPerformances>().eq("performances_id", performancesId));
                //修改mongo
                HashMap<String, Object> mapVo = new HashMap<>();
                mapVo.put("rejectTxt", rejectTxt);
                if (statusData.getStatus() <= 2) {
                    mapVo.put("status", status);
                }
                mapVo.put("auditStatus", auditStatus);
                object = new BasicDBObject("$set", mongoConverter.convertToMongoType(mapVo));
                mongoTemplate.getCollection(KylinPerformanceVo.class.getSimpleName()).updateOne(
                        Query.query(Criteria.where("performancesId").is(performancesId)).getQueryObject(),
                        object
                );
            } else {
                return false;
            }
            return true;
        } catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    @Override
    public PageInfo<PerformanceAdminListDao> getList(PerformanceAdminListParam performanceAdminListParam) {
        PageInfo<PerformanceAdminListDao> pageInfo;
        List<PerformanceAdminListDao> newList = new ArrayList();
        try {
            Map<String, Object> map = BeanUtil.convertBeanToMap(performanceAdminListParam);
            List<PerformanceAdminListDao> voList = performancesMapper.misPerformanceList(map);
            for (PerformanceAdminListDao item : voList) {
                if (item.getTimeSell() == null || item.getTimeStop() == null) {
                    continue;
                }
                item.setStatus(item.getStatus());
                if (item.getStatus() >= 6 && item.getStatus() != 7) {
                    if (DateUtil.compareStrDay(item.getTimeSell(), DateUtil.getNowTime()) > 0) {//未开始
                        item.setStatus(9);
                    } else if (DateUtil.compareStrDay(item.getTimeStop(), DateUtil.getNowTime()) < 0) {//已结束
                        item.setStatus(10);
                    } else {
                        item.setStatus(6);
                    }
                }
                newList.add(item);
            }
            pageInfo = new PageInfo(voList);
        } catch (Exception e) {
            e.printStackTrace();
            return null;
        }
        return pageInfo;
    }

    @Override
    public List<PerformanceTitleDao> getListByRoadShowId(String roadShowId) {
        try {
            List<PerformanceTitleDao> voList = performancesMapper.misTitleByRoadShowIdList(roadShowId);
            return voList;
        } catch (Exception e) {
            return new ArrayList<>();
        }
    }

    @Override
    public List<PerformanceTitleDao> getListByStatus(String status, String title) {
        List<PerformanceTitleDao> voList = performancesMapper.misTitleByStatusList(status, title);
        return voList;
    }

    @Override
    public List<PerformanceSimpleAllDao> getListDetailByStatus(String status, String title) {
        List<PerformanceTitleDao> dto1List = performancesMapper.misTitleByStatusList(status, title);
        if (dto1List.size() == 0) {
            return new ArrayList();
        } else {
            List<String> performanceIdList = dto1List.stream().map(PerformanceTitleDao::getPerformancesId).collect(Collectors.toList());
            List<PerformanceSimpleAllDao> dto2List = performancesMapper.misPerformanceDetail(performanceIdList);
            return dto2List;
        }
    }

    @Override
    public PerformanceSimpleAllDao getSimpleDetailByScopeAndId(String scope, String id) {
        switch (scope) {
            case "1":
                return performancesMapper.getPerformanceSimpleByPerformancesId(id);
            case "2":
                return performancesMapper.getPerformanceSimpleByTimesId(id);
            case "3":
                return performancesMapper.getPerformanceSimpleByTicketId(id);
            default:
                return null;
        }
    }

    @Override
    public boolean changeRoadShowId(String performancesId, String roadShowId) {
        try {
            //mysql
            if (null == roadShowId || roadShowId.isEmpty()) {
                roadShowId = "0";
            }
            KylinPerformanceRelations performanceRelations = new KylinPerformanceRelations();
            performanceRelations.setRoadShowId(roadShowId);
            performanceRelationsMapper.update(performanceRelations, new UpdateWrapper<KylinPerformanceRelations>().eq("performance_id", performancesId));

            performanceVoUtils.performanceVoStatus(performancesId);
            return true;
        } catch (Exception e) {
            return false;
        }
    }

    @Override
    public PerformanceRecommendDao getRecommend(String performancesId) {
        PerformanceRecommendDao result = performancesMapper.getRecommend(performancesId);
        return result;
    }

    @Override
    public boolean setRecommend(String performancesId, Integer isRecommend) {
        try {
            if (null == isRecommend) {
                isRecommend = 0;
            }
            KylinPerformanceStatus performanceStatus = new KylinPerformanceStatus();
            performanceStatus.setIsRecommend(isRecommend);
            performanceStatusMapper.update(performanceStatus, new UpdateWrapper<KylinPerformanceStatus>().eq("performance_id", performancesId));
            performanceVoUtils.performanceVoStatus(performancesId);
            return true;
        } catch (Exception e) {
            return false;
        }
    }

    @Override
    public Integer setIsShow(String performancesId, Integer isShow) {
        try {
            if (isShow == 0) {
                performanceStatusMapper.hideIsShow(performancesId);
            } else {
                performanceStatusMapper.showIsShow(performancesId);
            }
            HashMap<String, Object> map = new HashMap<>();
            map.put("isShow", isShow);
            BasicDBObject object = new BasicDBObject("$set", map);
            mongoTemplate.getCollection(PerformancePartnerVo.class.getSimpleName()).updateMany(
                    Query.query(Criteria.where("performancesId").is(performancesId)).getQueryObject(),
                    object
            );
            performanceVoUtils.performanceVoStatus(performancesId);
            return 1;
        } catch (Exception e) {
            e.printStackTrace();
            return 0;
        }
    }

    @Override
    public PageInfo<PerformanceRecommendAdminDao> listRecommend() {

        PageInfo<PerformanceRecommendAdminDao> pageInfoTmp = null;
        try {
            PageHelper.startPage(1, 10);
            List<PerformanceRecommendAdminDao> voList = performancesMapper.reCommendPerformanceList();
            List<PerformanceRecommendAdminDao> newList = new ArrayList();
            for (PerformanceRecommendAdminDao item : voList) {
                item.setStatus(item.getStatus());
                newList.add(item);
            }
            pageInfoTmp = new PageInfo(newList);
        } catch (Exception e) {
            return null;
        }
        return pageInfoTmp;
    }

    @Override
    public PerformanceMemberAuditDao performanceMemberInfo(String performanceId) {
        PerformanceMemberAuditDao performanceMemberAuditDao = new PerformanceMemberAuditDao();
        PerformanceTitleDao data = performancesMapper.misPerformanceMemberInfo(performanceId);
        List<TicketMemberAuditDao> ticketData = performancesMapper.misTicketMemberInfo(performanceId);
        performanceMemberAuditDao.setPerformancesId(data.getPerformancesId());
        performanceMemberAuditDao.setTitle(data.getTitle());
        performanceMemberAuditDao.setIsExclusive(0);
        performanceMemberAuditDao.setIsMember(0);
        performanceMemberAuditDao.setTicketMemberAudit(ticketData);
        for (TicketMemberAuditDao item : ticketData) {
            if (item.getIsMember() == 1) {
                performanceMemberAuditDao.setIsMember(1);
            }
            if (item.getIsExclusive() == 1) {
                performanceMemberAuditDao.setIsExclusive(1);
            }
        }
        boolean isExists = mongoTemplate.exists(Query.query(Criteria.where("status").is(1).and("performancesId").is(performanceId)), PerformanceMemberAuditParam.class, PerformanceMemberAuditParam.class.getSimpleName());
        if (isExists) {
            performanceMemberAuditDao.setIsSubmit(1);
        } else {
            performanceMemberAuditDao.setIsSubmit(0);
        }
        return performanceMemberAuditDao;
    }

    @Override
    public boolean performanceMemberChange(PerformanceMemberAuditParam performanceMemberAuditParam) {
        try {
            boolean isExists = mongoTemplate.exists(Query.query(Criteria.where("status").is(1).and("performancesId").is(performanceMemberAuditParam.getPerformancesId())), PerformanceMemberAuditParam.class, PerformanceMemberAuditParam.class.getSimpleName());
            if (isExists) {
                return false;
            } else {
                performanceMemberAuditParam.setStatus(1);
                mongoTemplate.insert(performanceMemberAuditParam, PerformanceMemberAuditParam.class.getSimpleName());
                return true;
            }
        } catch (Exception e) {
            return false;
        }
    }

    @Override
    public PageInfo<PerformanceTitleDao> performanceMemberList(String title, int page, int size) {
        PageInfo<PerformanceTitleDao> pageInfoTmp = null;
        // 排序 分页
        Pageable pageable = PageRequest.of(page, size, Sort.by(Sort.Direction.DESC, "createdAt"));
        //条件
        Criteria criteria = Criteria.where("status").is(1);
        if (!title.isEmpty()) {
            criteria.and("title").regex(".*?\\" + title);
        }
        Query query = Query.query(criteria);
        // 查询总数
        long count = mongoTemplate.count(query, PerformanceMemberAuditParam.class, PerformanceMemberAuditParam.class.getSimpleName());
        List<PerformanceMemberAuditParam> paramList = mongoTemplate.find(query, PerformanceMemberAuditParam.class, PerformanceMemberAuditParam.class.getSimpleName());
        query.with(pageable);
        //处理Vo
        List<PerformanceTitleDao> voList = new ArrayList<>();
        for (PerformanceMemberAuditParam item : paramList) {
            PerformanceTitleDao voData = new PerformanceTitleDao();
            voData.setPerformancesId(item.getPerformancesId());
            voData.setTitle(item.getTitle());
            voList.add(voData);
        }
        pageInfoTmp = new PageInfo(voList);
        pageInfoTmp.setTotal(count);

        return pageInfoTmp;
    }

    @Override
    public PerformanceMemberAuditDao performanceMemberAuditInfo(String performanceId, Integer status) {
        if (null == status) {
            status = 1;
        }
        PerformanceMemberAuditParam memberAuditVo = mongoTemplate.findOne(Query.query(Criteria.where("performancesId").is(performanceId).and("status").is(status)), PerformanceMemberAuditParam.class, PerformanceMemberAuditParam.class.getSimpleName());
        if (memberAuditVo == null) {
            return null;
        }

        PerformanceMemberAuditDao performanceMemberAuditDao = new PerformanceMemberAuditDao();
        PerformanceTitleDao data = performancesMapper.misPerformanceMemberInfo(performanceId);
        List<TicketMemberAuditDao> ticketData = performancesMapper.misTicketMemberInfo(performanceId);
        performanceMemberAuditDao.setPerformancesId(data.getPerformancesId());
        performanceMemberAuditDao.setTitle(data.getTitle());
        performanceMemberAuditDao.setIsExclusive(0);
        performanceMemberAuditDao.setIsMember(0);
        for (TicketMemberAuditDao item : ticketData) {
            if (memberAuditVo.getIsMember() == 1) {
                performanceMemberAuditDao.setIsMember(1);
            }
            if (memberAuditVo.getIsExclusive() == 1) {
                performanceMemberAuditDao.setIsExclusive(1);
            }
        }
        for (TicketMemberAuditParam item : memberAuditVo.getTicketMemberAudit()) {
            for (TicketMemberAuditDao item2 : ticketData) {
                if (item.getTicketsId().equals(item2.getTicketsId())) {
                    item2.setAdvanceMinuteMember(item.getAdvanceMinuteMember());
                    item2.setPriceDiscountMember(item.getPriceDiscountMember());
                    item2.setMemberLimitCount(item.getMemberLimitCount());
                    item2.setIsMember(performanceMemberAuditDao.getIsMember());
                    item2.setIsExclusive(performanceMemberAuditDao.getIsExclusive());
                    break;
                }
            }
        }
        performanceMemberAuditDao.setTicketMemberAudit(ticketData);

        return performanceMemberAuditDao;
    }

    @Override
    public boolean performanceMemberAudit(String performanceId, int status, String rejectTxt) {
        try {
            LocalDateTime updatedAt = LocalDateTime.now();
            if (status == 3) {
                PerformanceMemberAuditParam memberAuditVo = mongoTemplate.findOne(Query.query(Criteria.where("performancesId").is(performanceId).and("status").is(1)), PerformanceMemberAuditParam.class, PerformanceMemberAuditParam.class.getSimpleName());
                for (TicketMemberAuditParam item : memberAuditVo.getTicketMemberAudit()) {
                    //修改数据库
                    KylinTicketStatus ticketStatus = new KylinTicketStatus();
                    ticketStatus.setMemberLimitCount(item.getMemberLimitCount());
                    ticketStatus.setIsMember(memberAuditVo.getIsMember());
                    ticketStatus.setIsExclusive(memberAuditVo.getIsExclusive());
                    ticketStatus.setUpdatedAt(updatedAt);
                    ticketStatusMapper.update(ticketStatus, new UpdateWrapper<KylinTicketStatus>().eq("ticket_id", item.getTicketsId()));
                    KylinTickets tickets = new KylinTickets();
                    tickets.setAdvanceMinuteMember(item.getAdvanceMinuteMember());
                    tickets.setPriceDiscountMember(item.getPriceDiscountMember());
                    tickets.setUpdatedAt(updatedAt);
                    ticketsMapper.update(tickets, new UpdateWrapper<KylinTickets>().eq("tickets_id", item.getTicketsId()));
                }

                HashMap<String, Object> map2 = new HashMap<>();
                map2.put("status", 3);
                map2.put("updatedAt", updatedAt.format(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss")));
                map2.put("rejectTxt", "");
                BasicDBObject object = new BasicDBObject("$set", mongoConverter.convertToMongoType(map2));
                mongoTemplate.getCollection(PerformanceMemberAuditParam.class.getSimpleName()).updateOne(
                        Query.query(Criteria.where("performancesId").is(performanceId).and("status").is(1)).getQueryObject(),
                        object);
                new Thread().sleep(2000);
                performanceVoUtils.performanceVoStatus(performanceId);
            } else {
                HashMap<String, Object> map2 = new HashMap<>();
                map2.put("status", 2);
                map2.put("updatedAt", updatedAt.format(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss")));
                map2.put("rejectTxt", rejectTxt);
                BasicDBObject object = new BasicDBObject("$set", mongoConverter.convertToMongoType(map2));
                mongoTemplate.getCollection(PerformanceMemberAuditParam.class.getSimpleName()).updateOne(
                        Query.query(Criteria.where("performancesId").is(performanceId).and("status").is(1)).getQueryObject(),
                        object);
            }
            return true;
        } catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    @Override
    public PageInfo<PerformanceMemberAuditParam> performanceAuditHistory(String performanceId) {

        PageInfo<PerformanceMemberAuditParam> pageInfoTmp = null;
        // 排序 分页
        Pageable pageable = PageRequest.of(1, 100, Sort.by(Sort.Direction.DESC, "createdAt"));
        //条件
        Query query = Query.query(Criteria.where("status").ne(1).and("status").ne(0));

        // 查询总数
        long count = mongoTemplate.count(query, PerformanceMemberAuditParam.class, PerformanceMemberAuditParam.class.getSimpleName());
        List<PerformanceMemberAuditParam> paramList = mongoTemplate.find(query, PerformanceMemberAuditParam.class, PerformanceMemberAuditParam.class.getSimpleName());
        query.with(pageable);
        //处理Vo
        List<KylinPerformanceMemberHistoryVo> voList = new ArrayList<>();
        for (PerformanceMemberAuditParam item : paramList) {
            KylinPerformanceMemberHistoryVo voData = new KylinPerformanceMemberHistoryVo();
            voData.setAuditTime(item.getUpdatedAt());
            voData.setRejectTxt(item.getRejectTxt());
            voData.setStatus(item.getStatus());
            voList.add(voData);
        }
        pageInfoTmp = new PageInfo(paramList);
        pageInfoTmp.setTotal(count);

        return pageInfoTmp;
    }

    @Override
    public boolean changeTicketAgent(String performancesId, String ticketId, Integer status) {
        try {
            LocalDateTime updatedAt = LocalDateTime.now();
            if (status != 0 && status != 1) {
                return false;
            }
            //修改 mysql
            KylinTicketStatus ticketStatus = new KylinTicketStatus();
            ticketStatus.setUpdatedAt(updatedAt);
            ticketStatus.setIsAgent(status);
            ticketStatusMapper.update(ticketStatus, new UpdateWrapper<KylinTicketStatus>().eq("ticket_id", ticketId));
            performanceVoUtils.performanceVoStatus(performancesId);
            //存入票提默认 总代 普代都为0  默认0.000
            SmileAgent smileAgent = new SmileAgent();
            smileAgent.setPerformanceId(performancesId);
            smileAgent.setTicketId(ticketId);
            LambdaQueryWrapper<SmileAgent> queryWrapper = Wrappers.lambdaQuery(SmileAgent.class);
            queryWrapper.eq(SmileAgent::getPerformanceId, performancesId);
            queryWrapper.eq(SmileAgent::getTicketId, ticketId);
            if (status.equals(1)) {
                queryWrapper.eq(SmileAgent::getDelTag, 0);
                SmileAgent agent = smileAgentMapper.selectOne(queryWrapper);
                if (agent == null) {
                    smileAgentMapper.insert(smileAgent);
                }
            } else {
                smileAgent.setDelTag(1);
                smileAgentMapper.update(smileAgent, queryWrapper);
                //删除票提redis
                smileRedisUtils.delAgent(performancesId, ticketId);
                //查询是否还有设置过开启的票种
                agentCarryGtZeroByPerId(performancesId);
            }
            return true;
        } catch (Exception e) {
            return false;
        }
    }

    //校验该演出是否有其他票提设置  用于删除redis中演出id List
    private void agentCarryGtZeroByPerId(String performancesId) {
        List<SmileAgent> agents = smileAgentMapper.selectAgentCarryGtZeroByPerId(performancesId);
        if (agents.size() > 0) {
            //是否设置过票提
            boolean tag = true;
            for (SmileAgent agent : agents) {
                SmileAgentVo agent1 = smileRedisUtils.getAgent(agent.getPerformanceId(), agent.getTicketId());
                if (agent1 != null) {
                    tag = false;
                    break;
                }
            }
            if (tag) {
                //redis中删除演出id
                log.debug("查询没有设置过perId:{},删除演出列表id", performancesId);
                List<String> showIds = smileRedisUtils.getShowIds();
                showIds.remove(performancesId);
                smileRedisUtils.setShowIds(showIds);
            }
        } else {
            //删除演出ids
            List<String> showIds = smileRedisUtils.getShowIds();
            showIds.remove(performancesId);
            smileRedisUtils.setShowIds(showIds);
        }
    }

    @Override
    public boolean changeTicketPayTxt(String performancesId, String ticketId, String payTxt) {
        dataUtils.setTicketPayTxt(ticketId, payTxt);
        return true;
    }

    @Override
    public boolean changeSysDamai(List<SysDamaiParam> params) {
        try {
            LocalDateTime updatedAt = LocalDateTime.now();
            String performancesId = "";
            for (SysDamaiParam item : params) {
                if (item.getStatus() != 0 && item.getStatus() != 1) {
                    return false;
                }
                //修改 mysql
                if (item.getType().equals("ticket")) {
                    KylinTicketStatus ticketStatus = new KylinTicketStatus();
                    ticketStatus.setUpdatedAt(updatedAt);
                    ticketStatus.setSyncDamai(item.getStatus());
                    ticketStatusMapper.update(ticketStatus, new UpdateWrapper<KylinTicketStatus>().eq("ticket_id", item.getId()));
                } else if (item.getType().equals("performance")) {
                    performancesId = item.getId();
                    KylinPerformanceStatus performanceStatus = new KylinPerformanceStatus();
                    performanceStatus.setUpdatedAt(updatedAt);
                    performanceStatus.setSyncDamai(item.getStatus());
                    performanceStatusMapper.update(performanceStatus, new UpdateWrapper<KylinPerformanceStatus>().eq("performance_id", item.getId()));
                }
            }
            performanceVoUtils.performanceVoStatus(performancesId);
            return true;
        } catch (Exception e) {
            return false;
        }
    }

    @Override
    public PerformanceRefundConfigVo getRefundConfig(String performanceId) {
        KylinPerformances kylinPerformances = performancesMapper.selectOne(new UpdateWrapper<KylinPerformances>().eq("performances_id", performanceId));
        KylinPerformanceStatus kylinPerformanceStatus = performanceStatusMapper.selectOne(new UpdateWrapper<KylinPerformanceStatus>().eq("performance_id", performanceId));
        PerformanceRefundConfigVo vo = new PerformanceRefundConfigVo();
        vo.setPerformancesId(kylinPerformances.getPerformancesId());
        vo.setTitle(kylinPerformances.getTitle());
        vo.setIsCanRefund(kylinPerformanceStatus.getIsCanRefund());
        vo.setRefundCloseTime(kylinPerformanceStatus.getRefundCloseTime() == null ? "" : DateUtil.Formatter.yyyyMMddHHmmss.format(kylinPerformanceStatus.getRefundCloseTime()));
        vo.setRefundOpenTime(kylinPerformanceStatus.getRefundOpenTime() == null ? "" : DateUtil.Formatter.yyyyMMddHHmmss.format(kylinPerformanceStatus.getRefundOpenTime()));

//        vo.setIsRefundPoundage(kylinPerformanceStatus.getIsRefundPoundage());
        vo.setIsRefundVoucher(kylinPerformanceStatus.getIsRefundVoucher());
        vo.setIsRefundExpress(kylinPerformanceStatus.getIsRefundExpress());
        vo.setIsBackPaperTicket(kylinPerformanceStatus.getIsBackPaperTicket());
        vo.setIsRefundExpressNew(kylinPerformanceStatus.getIsRefundExpressNew());

        vo.setOrderRefundAddress(dataUtils.getRefundAddress());
        return vo;
    }

    @Override
    public String setPoundageExplain(String explain, String performanceId) {
        dataUtils.setRefundPoundageExplain(explain, performanceId);
        return explain;
    }

    @Override
    public String getPoundageExplain(String performanceId) {
        return dataUtils.getRefundPoundageExplain(performanceId);
    }

    @Override
    public String setRefundPoundageAll(List<OrderRefundPoundage> orderRefundPoundageArrayList, String performanceId) {

        if (orderRefundPoundageArrayList.size() > 10) {
            return "阶梯不能大于10";
        }

        PerformanceRefundConfigVo configVo = getRefundConfig(performanceId);
        if (configVo.getIsCanRefund() == 1) {
            return "请先关闭退款再进行操作";
        }

        int count = kylinOrderRefundsMapper.selectingCount(performanceId);
        if (count > 0) {
            return "请先处理该演出待退款订单再进行操作";
        }

        LocalDateTime nextTime = LocalDateTime.parse("2001-01-01 12:00:00", DTF_YMD_HMS);
        for (OrderRefundPoundage item : orderRefundPoundageArrayList) {
            if (item.getPresent().compareTo(BigDecimal.ONE) > 0) {
                return "手续费不能大于100%";
            }
            LocalDateTime curTime = LocalDateTime.parse(item.getDay(), DTF_YMD_HMS);
            if (curTime.isBefore(nextTime)) {
                return "当前阶梯时间不能早于前一个阶梯";
            }
            nextTime = curTime;
        }
        if (orderRefundPoundageArrayList.size() > 1) {
            LocalDateTime st = LocalDateTime.parse(configVo.getRefundOpenTime(), DTF_YMD_HMS);
            LocalDateTime et = LocalDateTime.parse(configVo.getRefundCloseTime(), DTF_YMD_HMS);
            LocalDateTime ft = LocalDateTime.parse(orderRefundPoundageArrayList.get(0).getDay(), DTF_YMD_HMS);
            LocalDateTime lt = LocalDateTime.parse(orderRefundPoundageArrayList.get(orderRefundPoundageArrayList.size() - 1).getDay(), DTF_YMD_HMS);
            if (ft.isBefore(st)) {
                return orderRefundPoundageArrayList.get(0).getDay() + "超出退款时间范围";
            } else if (lt.isAfter(et)) {
                return orderRefundPoundageArrayList.get(orderRefundPoundageArrayList.size() - 1).getDay() + "超出退款时间范围";
            }
        }
        dataUtils.setRefundPoundage(orderRefundPoundageArrayList, performanceId);
        return "操作成功";
    }

    @Override
    public ArrayList<OrderRefundPoundage> getRefundPoundageAll(String performanceId) {
        return dataUtils.getRefundPoundage(performanceId);
    }

    @Override
    public PerformanceTransferConfigVo getTransferConfig(String performanceId) {
        KylinPerformances kylinPerformances = performancesMapper.selectOne(new UpdateWrapper<KylinPerformances>().eq("performances_id", performanceId));
        KylinPerformanceStatus kylinPerformanceStatus = performanceStatusMapper.selectOne(new UpdateWrapper<KylinPerformanceStatus>().eq("performance_id", performanceId));
        PerformanceTransferConfigVo vo = new PerformanceTransferConfigVo();
        vo.setPerformancesId(kylinPerformances.getPerformancesId());
        vo.setTitle(kylinPerformances.getTitle());
        vo.setIsCanTransfer(kylinPerformanceStatus.getIsTransfer());
        vo.setTransferStartTime(kylinPerformanceStatus.getTransferStartTime() == null ? "" : DateUtil.Formatter.yyyyMMddHHmmss.format(kylinPerformanceStatus.getTransferStartTime()));
        vo.setTransferEndTime(kylinPerformanceStatus.getTransferEndTime() == null ? "" : DateUtil.Formatter.yyyyMMddHHmmss.format(kylinPerformanceStatus.getTransferEndTime()));
        return vo;
    }

    @Override
    public List<KylinOrderImport> getOrderImport(String performanceId) {
        return orderImportMapper.selectList(Wrappers.lambdaQuery(KylinOrderImport.class).eq(KylinOrderImport::getPerformanceId, performanceId)
                .orderByDesc(KylinOrderImport::getCreatedAt));
    }

    @Override
    public String changeTransferConfig(String performancesId,
                                       Integer isCanTransfer,
                                       String transferStartTime,
                                       String transferEndTime) {
        KylinPerformanceStatus kylinPerformanceStatusData = performanceStatusMapper.selectOne(new UpdateWrapper<KylinPerformanceStatus>().eq("performance_id", performancesId));
        if (kylinPerformanceStatusData.getIsCanRefund().equals(1) && isCanTransfer.equals(1)) {
            return "修改失败，演出已开启退款";
        }
        KylinPerformances kylinPerformances = performancesMapper.selectOne(new UpdateWrapper<KylinPerformances>().eq("performances_id", performancesId));
        if (!(kylinPerformances.getType().equals(1) || kylinPerformances.getType().equals(101))) {
            return "修改失败，只支持音乐节类型演出";
        }


        KylinPerformanceStatus kylinPerformanceStatus = new KylinPerformanceStatus();
        kylinPerformanceStatus.setIsTransfer(isCanTransfer);
        kylinPerformanceStatus.setTransferStartTime(DateUtil.Formatter.yyyyMMddHHmmss.parse(transferStartTime));
        kylinPerformanceStatus.setTransferEndTime(DateUtil.Formatter.yyyyMMddHHmmss.parse(transferEndTime));
        try {
            performanceStatusMapper.update(kylinPerformanceStatus, new UpdateWrapper<KylinPerformanceStatus>().eq("performance_id", performancesId));
            performanceVoUtils.performanceVoStatus(performancesId);
            return "修改成功";
        } catch (Exception e) {
            e.printStackTrace();
            return "修改失败";
        }
    }

    @Override
    public String changeRefundConfig(String performancesId,
                                     Integer isCanRefund,
                                     String refundOpenTime,
                                     String refundCloseTime,
                                     Integer isRefundPoundage,
                                     Integer isRefundVoucher,
                                     Integer isRefundExpress,
                                     Integer isBackPaperTicket,
                                     Integer isRefundExpressNew) {
        KylinPerformanceStatus kylinPerformanceStatusData = performanceStatusMapper.selectOne(new UpdateWrapper<KylinPerformanceStatus>().eq("performance_id", performancesId));
        if (kylinPerformanceStatusData.getIsTransfer().equals(1) && isCanRefund.equals(1)) {
            return "修改失败，演出已开启转赠";
        }

        KylinPerformanceStatus kylinPerformanceStatus = new KylinPerformanceStatus();
        kylinPerformanceStatus.setIsCanRefund(isCanRefund);
        kylinPerformanceStatus.setRefundOpenTime(DateUtil.Formatter.yyyyMMddHHmmss.parse(refundOpenTime));
        kylinPerformanceStatus.setRefundCloseTime(DateUtil.Formatter.yyyyMMddHHmmss.parse(refundCloseTime));
        kylinPerformanceStatus.setIsRefundPoundage(isRefundPoundage);
        kylinPerformanceStatus.setIsRefundVoucher(isRefundVoucher);
        kylinPerformanceStatus.setIsRefundExpress(isRefundExpress);
        kylinPerformanceStatus.setIsBackPaperTicket(isBackPaperTicket);
        kylinPerformanceStatus.setIsRefundExpressNew(isRefundExpressNew);

        try {
            performanceStatusMapper.update(kylinPerformanceStatus, new UpdateWrapper<KylinPerformanceStatus>().eq("performance_id", performancesId));
            performanceVoUtils.performanceVoStatus(performancesId);
            return "修改成功";
        } catch (Exception e) {
            e.printStackTrace();
            return "修改失败";
        }
    }

    @Override
    public KylinPerformanceAgentVo getPerformanceAgent(String performancesId) {
        KylinPerformances performanceData = performancesMapper.selectOne(new UpdateWrapper<KylinPerformances>().eq("performances_id", performancesId));
        List<TicketAgentDao> ticketData = ticketsMapper.ticketAgent(performancesId);
        KylinPerformanceAgentVo vo = new KylinPerformanceAgentVo();
        vo.setPerformancesId(performanceData.getPerformancesId());
        vo.setTitle(performanceData.getTitle());
        vo.setTickets(ticketData);
        return vo;
    }

    @Override
    public KylinPerformancePayTxtVo getPerformancePayTxt(String performancesId) {
        KylinPerformances performanceData = performancesMapper.selectOne(new UpdateWrapper<KylinPerformances>().eq("performances_id", performancesId));
        List<TicketAgentDao> ticketData = ticketsMapper.ticketAgent(performancesId);
        KylinPerformancePayTxtVo vo = new KylinPerformancePayTxtVo();
        vo.setPerformancesId(performanceData.getPerformancesId());
        vo.setTitle(performanceData.getTitle());
        List<TicketPayTxtDao> payTxtDaoList = new ArrayList();
        for (TicketAgentDao item : ticketData) {
            TicketPayTxtDao payTxtDao = new TicketPayTxtDao();
            payTxtDao.setTicketsId(item.getTicketsId());
            payTxtDao.setTitle(item.getTitle());
            payTxtDao.setPayTxt(dataUtils.getTicketPayTxt(item.getTicketsId()));
            payTxtDaoList.add(payTxtDao);
        }
        vo.setTickets(payTxtDaoList);
        return vo;
    }

    public KylinPerformanceDamaiVo getPerformanceDamai(String performancesId) {
        KylinPerformances performanceData = performancesMapper.selectOne(new UpdateWrapper<KylinPerformances>().eq("performances_id", performancesId));
        KylinPerformanceStatus performanceStatusData = performanceStatusMapper.selectOne(new UpdateWrapper<KylinPerformanceStatus>().eq("performance_id", performancesId));
        List<TicketDamaiDao> ticketData = ticketsMapper.ticketDamai(performancesId);
        KylinPerformanceDamaiVo vo = new KylinPerformanceDamaiVo();
        vo.setPerformancesId(performanceData.getPerformancesId());
        vo.setTitle(performanceData.getTitle());
        vo.setSyncDamai(performanceStatusData.getSyncDamai());
        vo.setDamaiTickets(ticketData);
        return vo;
    }

    @Override
    public List<PerformanceOrderStatisticalDao> getPerformanceOrderStatisticalList(String performancesId) {
        PerformanceOrderStatisticalDao countBean = new PerformanceOrderStatisticalDao();
        countBean.setTitle("总计：");

        List<PerformanceOrderStatisticalDao> dtoList = performancesMapper.getPerformanceOrderStatisticalList(performancesId);
        dtoList.forEach(dto -> {
            countBean.setTotalGeneral(countBean.getTotalGeneral().add(dto.getTotalGeneral()));
            countBean.setSaleGeneral(countBean.getSaleGeneral().add(dto.getSaleGeneral()));
            countBean.setSurplusGeneral(countBean.getSurplusGeneral().add(dto.getSurplusGeneral()));
            countBean.setTotalSalePrice(countBean.getTotalSalePrice().add(dto.getTotalSalePrice()));
            countBean.setTotalExchange(countBean.getTotalExchange().add(dto.getTotalExchange()));
            countBean.setTotalRefundGeneral(countBean.getTotalRefundGeneral().add(dto.getTotalRefundGeneral()));
            countBean.setTotalRefundPrice(countBean.getTotalRefundPrice().add(dto.getTotalRefundPrice()));
            countBean.setTotalMemberNumber(countBean.getTotalMemberNumber().add(dto.getTotalMemberNumber()));
            countBean.setTotalPayingNumber(countBean.getTotalPayingNumber().add(dto.getTotalPayingNumber()));
            countBean.setTotalVoucherCount(countBean.getTotalVoucherCount().add(dto.getTotalVoucherCount()));
            countBean.setTotalBuyUsers(dto.getTotalBuyUsers());
        });
        dtoList.add(countBean);
        return dtoList;
    }

    @Override
    public List<PerformanceSponsorDao> getPerformanceSponsorList(String sponsorType) {
        return performancesMapper.getPerformanceSponsorList(sponsorType);
    }

    @Override
    public List<KylinPerformanceSubscribeTicketStatisticalDao> getPerformanceSubscribe(String performancesId) {
        return performancesMapper.getSubscribeTicketStatisticalByPerformancesId(performancesId);
    }

    //删除演出下所有订单缓存(订单详情，订单列表)
    public void delOrderTicketsRedis(KylinPerformanceMisVo vo) {
        //找到所有ticketId
        List<TicketTimesTicketCreatePartnerVo> timesVoList = vo.getTicketTimes();
        for (TicketTimesTicketCreatePartnerVo timesVo : timesVoList) {
            for (KylinTicketPartnerVo ticketVo : timesVo.getTicket()) {
                List<String> orderTicketRedisIdList = new ArrayList<>();
                List<String> userRedisIdList = new ArrayList<>();
                List<String> orderTicketIdList = new ArrayList<>();
                log.info("修改场次相关 mysql ticketId -> " + ticketVo.getTicketsId());
                List<OrderIdsDao> orderIdsDaoList = kylinOrderTicketsMapper.getOrderUserIdByTimesId(ticketVo.getTicketsId());
                log.info("修改场次相关 mysql data -> " + orderIdsDaoList.size());
                for (OrderIdsDao item : orderIdsDaoList) {
                    orderTicketRedisIdList.add(KylinRedisConst.ORDER + item.getOrderTicketsId());
                    userRedisIdList.add(KylinRedisConst.ORDER_LIST + item.getUserId());
                    orderTicketIdList.add(item.getOrderTicketsId());
                }
                HashMap<String, Object> mapMongo = new HashMap<>();
                mapMongo.put("useStart", ticketVo.getUseStart());
                mapMongo.put("timeStart", vo.getTimeStart());
                long time1 = System.currentTimeMillis();
                mongoTemplate.getCollection(KylinOrderTicketVo.class.getSimpleName()).updateMany(
                        Query.query(Criteria.where("orderTicketsId").in(orderTicketIdList)).getQueryObject(),
                        new BasicDBObject("$set", mongoConverter.convertToMongoType(mapMongo))
                );
                mapMongo.put("useEnd", ticketVo.getUseEnd());
                mongoTemplate.getCollection(KylinOrderTicketEntitiesVo.class.getSimpleName()).updateMany(
                        Query.query(Criteria.where("orderId").in(orderTicketIdList)).getQueryObject(),
                        new BasicDBObject("$set", mongoConverter.convertToMongoType(mapMongo))
                );
                log.debug("修改场次相关 mongo time -> " + (System.currentTimeMillis() - time1) + " ms ");

                time1 = System.currentTimeMillis();
                dataUtils.delOrderIdUserIdRedis(orderTicketRedisIdList, userRedisIdList);
                log.debug("修改场次相关 redis time -> " + (System.currentTimeMillis() - time1) + " ms ");
            }
        }
    }
}
