package com.liquidnet.service.sweet.entity;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.io.Serializable;
import java.util.Date;

/**
 * 失物招领信息实体类
 *
 * @author liquidnet
 * @since 2025-01-18
 */
@ApiModel("失物招领信息")
@Data
@EqualsAndHashCode(callSuper = false)
public class SweetLostFoundItem implements Serializable, Cloneable {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty("主键ID")
    @TableId(value = "id", type = IdType.AUTO)
    private Long id;

    @ApiModelProperty("失物信息ID")
    private String itemId;

    @ApiModelProperty("物品图片URL")
    private String itemImage;

    @ApiModelProperty("物品描述，最多120字")
    private String description;

    @ApiModelProperty("拾捡地：1-音乐节现场 2-其他")
    private Integer pickupLocation;

    @ApiModelProperty("捡拾日期")
    private String pickupDate;

    @ApiModelProperty("物品类型：1-证件卡类 2-3C数码类 3-服饰类 4-其他")
    private Integer itemType;

    @ApiModelProperty("演出ID")
    private String performanceId;

    @ApiModelProperty("创建时间")
    private Date createTime;

    @ApiModelProperty("更新时间")
    private Date updateTime;

    @ApiModelProperty("是否删除：0-未删除 1-已删除")
    private Integer isDeleted;


    private static final SweetLostFoundItem obj = new SweetLostFoundItem();

    public static SweetLostFoundItem getNew() {
        try {
            return (SweetLostFoundItem) obj.clone();
        } catch (CloneNotSupportedException e) {
            return new SweetLostFoundItem();
        }
    }

    // 拾捡地枚举
    public enum PickupLocation {
        FESTIVAL_SITE(1, "音乐节现场"),
        OTHER_PLACE(2, "其他");

        private final int code;
        private final String desc;

        PickupLocation(int code, String desc) {
            this.code = code;
            this.desc = desc;
        }

        public int getCode() {
            return code;
        }

        public String getDesc() {
            return desc;
        }
    }

    // 物品类型枚举
    public enum ItemType {
        DOCUMENT_CARD(1, "证件卡类"),
        DIGITAL_DEVICE(2, "3C数码类"),
        CLOTHING(3, "服饰类"),
        OTHER(4, "其他");

        private final int code;
        private final String desc;

        ItemType(int code, String desc) {
            this.code = code;
            this.desc = desc;
        }

        public int getCode() {
            return code;
        }

        public String getDesc() {
            return desc;
        }
    }

}