-- 草莓演出失物招领功能数据库表结构
-- 创建时间: 2025-01-18
-- 表前缀: sweet_

-- 失物招领管理员表
CREATE TABLE IF NOT EXISTS `sweet_lost_found_admin`
(
    `id`              bigint(20)  NOT NULL AUTO_INCREMENT COMMENT '主键ID',
    `admin_id`        varchar(64) NOT NULL DEFAULT '' COMMENT '管理员ID',
    `phone`           varchar(11) NOT NULL DEFAULT '' COMMENT '手机号',
    `name`            varchar(50) NOT NULL DEFAULT '' COMMENT '备注姓名',
    `permission_type` tinyint(1)  NOT NULL DEFAULT 1 COMMENT '权限类型：1-发帖员(仅发帖,发布后不可编辑) 2-管理员(发帖、编辑、删除)',
    `auth_scope`      tinyint(1)  NOT NULL DEFAULT 1 COMMENT '授权范围：1-本站次 2-全站',
    `performance_id`  varchar(64) NOT NULL DEFAULT '' COMMENT '演出ID',
    `create_time`     datetime    NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
    `update_time`     datetime    NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '更新时间',
    `is_deleted`      tinyint(1)  NOT NULL DEFAULT 0 COMMENT '是否删除：0-未删除 1-已删除',
    PRIMARY KEY (`id`),
    UNIQUE KEY `uk_admin_id` (`admin_id`),
    KEY `idx_phone` (`phone`),
    KEY `idx_performance_id` (`performance_id`)
) ENGINE = InnoDB
  DEFAULT CHARSET = utf8mb4 COMMENT ='失物招领管理员表';

-- 失物招领信息表
CREATE TABLE IF NOT EXISTS `sweet_lost_found_item`
(
    `id`              bigint(20)   NOT NULL AUTO_INCREMENT COMMENT '主键ID',
    `item_id`         varchar(64)  NOT NULL DEFAULT '' COMMENT '失物信息ID',
    `item_image`      varchar(500) NOT NULL DEFAULT '' COMMENT '物品图片URL',
    `description`     varchar(500) NOT NULL DEFAULT '' COMMENT '物品描述，最多120字',
    `pickup_location` tinyint(1)   NOT NULL DEFAULT 1 COMMENT '拾捡地：1-音乐节现场 2-其他',
    `pickup_date`     varchar(20)  NOT NULL DEFAULT '' COMMENT '捡拾日期',
    `item_type`       tinyint(1)   NOT NULL DEFAULT 1 COMMENT '物品类型：1-证件卡类 2-3C数码类 3-服饰类 4-其他',
    `performance_id`  varchar(64)  NOT NULL DEFAULT '' COMMENT '演出ID',
    `create_time`     datetime     NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
    `update_time`     datetime     NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '更新时间',
    `is_deleted`      tinyint(1)   NOT NULL DEFAULT 0 COMMENT '是否删除：0-未删除 1-已删除',
    PRIMARY KEY (`id`),
    UNIQUE KEY `uk_item_id` (`item_id`),
    KEY `idx_performance_id` (`performance_id`)
) ENGINE = InnoDB
  DEFAULT CHARSET = utf8mb4 COMMENT ='失物招领信息表';