package com.liquidnet.service.adam.controller;

import com.liquidnet.common.cache.redis.util.RedisUtil;
import com.liquidnet.commons.lang.util.DESUtils;
import com.liquidnet.service.base.ResponseDto;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Slf4j
@RestController
@RequestMapping("ath")
public class GlobalAuthorityController {
    @Autowired
    RedisUtil redisUtil;

    @PostMapping("check")
    public ResponseDto<String> check(@RequestParam String seal) {
        try {
            String sealDecrypt = DESUtils.DES().decrypt(seal);

            Object valObj = redisUtil.get(sealDecrypt);

            String valEncrypt = null;
            if (null != valObj) {
                if (valObj instanceof String) {
                    valEncrypt = DESUtils.DES().encrypt((String) valObj);
                } else if (valObj instanceof Integer) {
                    valEncrypt = DESUtils.DES().encrypt(valObj.toString());
                }
            }

            return ResponseDto.success(valEncrypt);
        } catch (Exception e) {
            log.error("auth.check decrypt exception", e);
            return ResponseDto.failure("Invalid seal");
        }
    }
}
