package com.liquidnet.service.goblin.dto.vo;

import com.liquidnet.service.smile.entity.SmileVolunteersTeam;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;

/**
 * <p>
 *
 * </p>
 *
 * @author jobob
 * @since 2022-03-11
 */
@ApiModel(value = "SmileVProjectListVo")
@Data
public class SmileVTeamVo implements Serializable, Cloneable {

    private static final long serialVersionUID = 1L;
    @ApiModelProperty(value = "活动id")
    private String teamId;
    @ApiModelProperty(value = "标题")
    private String name;
    @ApiModelProperty(value = "组介绍")
    private String introduce;
    @ApiModelProperty(value = "用户是否选择[0-未选择|1-已选择]")
    private Integer status;

    private static final SmileVTeamVo obj = new SmileVTeamVo();

    public static SmileVTeamVo getNew() {
        try {
            return (SmileVTeamVo) obj.clone();
        } catch (CloneNotSupportedException e) {
            return new SmileVTeamVo();
        }
    }

    public SmileVTeamVo copy(SmileVolunteersTeam source,Integer checkStatus) {
        this.setTeamId(source.getTeamId());
        this.setName(source.getName());
        this.setIntroduce(source.getIntroduce());
        this.setStatus(checkStatus);
        return this;
    }
}
